<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'categories';
    protected $fillable = ['mainid', 'subid', 'role', 'name', 'slug', 'status'];
    public $timestamps = false;

    // Get main category
    public function mainCategory()
    {
        return $this->belongsTo(Category::class, 'mainid');
    }

    // Get sub category
    public function subCategory()
    {
        return $this->belongsTo(Category::class, 'subid');
    }

    // Get children categories
    public function children()
    {
        return $this->hasMany(Category::class, 'mainid')->where('role', 'sub')->where('status', 1);
    }

    // Get child of subcategories
    public function subChildren()
    {
        return $this->hasMany(Category::class, 'subid')->where('role', 'child')->where('status', 1);
    }

    // Scope active categories
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
