<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Category;
use App\Product;
use App\ServiceSection;
use App\Testimonial;
use App\Slider;
use App\SectionTitles;
use App\Review;

class FrontEndController extends Controller
{
    public function index()
    {
        // Get active sliders
        $sliders = Slider::where('status', 1)->get(); // Replace 'active()' if scope not defined

        // Get active services
        $services = ServiceSection::where('status', 1)->get();

        // Feature products
        $features = Product::where('feature', 1)->get(); // Replace 'feature()' if scope not defined

        // Latest products
        $latests = Product::orderBy('created_at', 'desc')->take(8)->get();

        // Popular products
        $tops = Product::orderBy('views', 'desc')->take(8)->get(); // Replace 'popular()' if scope not defined

        // Active testimonials
        $testimonials = Testimonial::where('status', 1)->get();

        // Language settings
        $languages = SectionTitles::first();

        // Categories with subcategories
        $categories = Category::where('status', 1)
            ->where('role', 'main')
            ->with('children.subChildren')
            ->get();

        return view('index', compact(
            'sliders',
            'services',
            'features',
            'latests',
            'tops',
            'testimonials',
            'languages',
            'categories'
        ));
    }
}
