<?php
// Quick script to check database tables
$host = '127.0.0.1';
$db = 'ecom';
$user = 'root';
$pass = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Connected to database: $db\n\n";
    echo "=== TABLES IN DATABASE ===\n\n";
    
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tables)) {
        echo "No tables found in database.\n";
    } else {
        foreach ($tables as $index => $table) {
            echo ($index + 1) . ". $table\n";
        }
        
        echo "\n\n=== TABLE STRUCTURES ===\n\n";
        
        foreach ($tables as $table) {
            echo "TABLE: $table\n";
            echo str_repeat("-", 80) . "\n";
            
            $stmt = $pdo->query("DESCRIBE $table");
            $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($columns as $column) {
                echo sprintf("  %-25s %-20s %-10s %-10s\n", 
                    $column['Field'], 
                    $column['Type'], 
                    $column['Null'], 
                    $column['Key']
                );
            }
            echo "\n";
        }
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
