<?php
// debug_boot.php
// This script attempts to bootstrap the Laravel application and catch any errors

define('LARAVEL_START', microtime(true));

require __DIR__.'/vendor/autoload.php';

try {
    $app = require_once __DIR__.'/bootstrap/app.php';

    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

    echo "Application booted successfully.\n";
    
    // Try to run a simple command
    $input = new Symfony\Component\Console\Input\ArrayInput(['command' => '--version']);
    $output = new Symfony\Component\Console\Output\BufferedOutput;
    
    $status = $kernel->handle(
        $input,
        $output
    );
    
    echo "Output: " . $output->fetch();

} catch (Throwable $e) {
    echo "CAUGHT EXCEPTION:\n";
    echo "Message: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "Trace:\n" . $e->getTraceAsString() . "\n";
} catch (Exception $e) {
    echo "CAUGHT EXCEPTION (Legacy):\n";
    echo "Message: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
