<?php
// debug_boot_file.php
// Writes errors to a file to avoid truncation

define('LARAVEL_START', microtime(true));

require __DIR__.'/vendor/autoload.php';

$logFile = __DIR__ . '/debug_error.log';
file_put_contents($logFile, "Starting debug...\n");

try {
    $app = require_once __DIR__.'/bootstrap/app.php';

    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

    file_put_contents($logFile, "Application booted successfully.\n", FILE_APPEND);
    
    // Try to run a simple command
    $input = new Symfony\Component\Console\Input\ArrayInput(['command' => '--version']);
    $output = new Symfony\Component\Console\Output\BufferedOutput;
    
    $status = $kernel->handle(
        $input,
        $output
    );
    
    file_put_contents($logFile, "Command Output: " . $output->fetch() . "\n", FILE_APPEND);

} catch (Throwable $e) {
    $msg = "CAUGHT EXCEPTION:\n";
    $msg .= "Message: " . $e->getMessage() . "\n";
    $msg .= "File: " . $e->getFile() . "\n";
    $msg .= "Line: " . $e->getLine() . "\n";
    $msg .= "Trace:\n" . $e->getTraceAsString() . "\n";
    file_put_contents($logFile, $msg, FILE_APPEND);
} catch (Exception $e) {
    $msg = "CAUGHT EXCEPTION (Legacy):\n";
    $msg .= "Message: " . $e->getMessage() . "\n";
    $msg .= "File: " . $e->getFile() . "\n";
    $msg .= "Line: " . $e->getLine() . "\n";
    file_put_contents($logFile, $msg, FILE_APPEND);
}
