@extends('includes.master')
@section('content')

<!-- SLIDER -->
<section class="go-slider">
    <div id="bootstrap-touch-slider" class="carousel bs-slider fade control-round indicators-line" data-ride="carousel" data-pause="hover" data-interval="5000">

        <div class="carousel-inner" role="listbox">
            @foreach($sliders as $i => $slider)
                <div class="item {{ $i == 0 ? 'active' : '' }}">
                    <img src="{{ url('/assets/images/sliders/' . $slider->image) }}" class="slide-image" alt="{{ $slider->title }}">
                    <div class="bs-slider-overlay"></div>
                    <div class="container">
                        <div class="row">
                            <div class="slide-text {{ $slider->text_position }}">
                                <h1>{{ $slider->title }}</h1>
                                <p>{{ $slider->text }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <a class="left carousel-control" href="#bootstrap-touch-slider" role="button" data-slide="prev">
            <span class="fa fa-angle-left"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="right carousel-control" href="#bootstrap-touch-slider" role="button" data-slide="next">
            <span class="fa fa-angle-right"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
</section>

<!-- SERVICES -->
<section class="wow fadeInUp go-services hideme">
    <div class="row" style="margin-top:70px;">
        <div class="container">
            <div class="col-md-6 col-md-offset-3">
                <div class="section-title">
                    <h2>{{ $languages->service_title }}</h2>
                    <p>{{ $languages->service_text }}</p>
                </div>
            </div>

            @foreach($services as $service)
                <div class="col-xs-12 col-md-4">
                    <div class="service-list text-center wow fadeInUp">
                        <img src="{{ url('/assets/images/service/' . $service->icon) }}" alt="">
                        <h3>{{ $service->title }}</h3>
                        <p>{{ $service->text }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- CATEGORIES -->
<section class="wow fadeInUp go-categories hideme">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-6 col-md-offset-3">
                <div class="section-title">
                    <h2>Categories</h2>
                    <p>Browse our product categories</p>
                </div>
            </div>
        </div>
        <div class="row">
            @foreach($categories as $main)
                <div class="col-md-4">
                    <h3>{{ $main->name }}</h3>
                    @foreach($main->children as $sub)
                        <h5>-- {{ $sub->name }}</h5>
                        @foreach($sub->subChildren as $child)
                            <p>---- {{ $child->name }}</p>
                        @endforeach
                    @endforeach
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- PRODUCTS TAB (Features, Latest, Popular) -->
<section class="wow fadeInUp go-products">
    <div class="container">
        <div class="row">
            <div class="card col-md-12">
                <ul class="nav nav-tabs home-tab" role="tablist">
                    <li class="active"><a href="#home" role="tab" data-toggle="tab">Feature Products</a></li>
                    <li><a href="#profile" role="tab" data-toggle="tab">Latest Products</a></li>
                    <li><a href="#messages" role="tab" data-toggle="tab">Popular Products</a></li>
                </ul>

                <div class="tab-content">
                    <!-- FEATURE -->
                    <div role="tabpanel" class="tab-pane fade in active" id="home">
                        <div class="row">
                            @foreach($features as $product)
                                @include('partials.product-card', ['product' => $product])
                            @endforeach
                        </div>
                    </div>

                    <!-- LATEST -->
                    <div role="tabpanel" class="tab-pane fade" id="profile">
                        <div class="row">
                            @foreach($latests as $product)
                                @include('partials.product-card', ['product' => $product])
                            @endforeach
                        </div>
                    </div>

                    <!-- POPULAR -->
                    <div role="tabpanel" class="tab-pane fade" id="messages">
                        <div class="row">
                            @foreach($tops as $product)
                                @include('partials.product-card', ['product' => $product])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- TESTIMONIALS -->
<section class="wow fadeInUp testimonials hideme">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-6 col-md-offset-3">
                <div class="section-title">
                    <h2>{{ $languages->testimonial_title }}</h2>
                    <p>{{ $languages->testimonial_text }}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-12">
            <div id="customers-testimonials" class="owl-carousel">
                @foreach($testimonials as $testimonial)
                    <div class="item">
                        <div class="shadow-effect">
                            <i class="fa fa-quote-right"></i>
                            <div class="item-details">
                                <p>{{ $testimonial->review }}</p>
                                <h5>{{ $testimonial->client }}</h5>
                                <p>{{ $testimonial->designation }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

@stop
