@extends('includes.master')

@section('content')

<section class="container" style="margin-top: 20px;">
    <div class="content-push">

        <div class="breadcrumb-box">
            <a href="{{ url('/') }}">Home</a>
            @foreach($categories as $cat)
                <a href="{{ url('/category/' . $cat->slug) }}">{{ $cat->name }}</a>
            @endforeach
            <a href="{{ url('/product/' . $productdata->id . '/' . Str::slug($productdata->title)) }}">{{ $productdata->title }}</a>
        </div>

        <div class="information-blocks">
            <div class="row">

                <!-- PRODUCT IMAGES -->
                <div class="col-sm-5 col-md-4 col-lg-5 information-entry">
                    <div class="product-preview-box">
                        <div class="swiper-container product-preview-swiper">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="product-zoom-image">
                                        <img src="{{ url('/assets/images/products/' . $productdata->feature_image) }}" alt="" />
                                    </div>
                                </div>
                                @forelse($gallery as $galdta)
                                    <div class="swiper-slide">
                                        <div class="product-zoom-image">
                                            <img src="{{ url('/assets/images/gallery/' . $galdta->image) }}" alt="" />
                                        </div>
                                    </div>
                                @empty
                                @endforelse
                            </div>
                            <div class="pagination"></div>
                        </div>
                        <div class="swiper-hidden-edges">
                            <div class="swiper-container product-thumbnails-swiper">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide selected">
                                        <div class="paddings-container">
                                            <img src="{{ url('/assets/images/products/' . $productdata->feature_image) }}" alt="" />
                                        </div>
                                    </div>
                                    @forelse($gallery as $galdta)
                                        <div class="swiper-slide">
                                            <div class="paddings-container">
                                                <img src="{{ url('/assets/images/gallery/' . $galdta->image) }}" alt="" />
                                            </div>
                                        </div>
                                    @empty
                                    @endforelse
                                </div>
                                <div class="pagination"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- PRODUCT DETAILS -->
                <div class="col-sm-7 col-md-7 information-entry">
                    <div class="product-detail-box">
                        <h1 class="product-title">{{ $productdata->title }}</h1>

                        @if($productdata->owner != 'admin' && $productdata->vendor)
                            <strong>Vendor: 
                                <a href="{{ url('/shop/' . $productdata->vendorid . '/' . Str::slug($productdata->vendor->shop_name)) }}" target="_blank">
                                    {{ $productdata->vendor->shop_name }}
                                </a>
                            </strong>
                        @endif

                        @if($productdata->stock != 0 || $productdata->stock === null)
                            <h3 class="product-subtitle"><i class="fa fa-check-circle fa-fw"></i> Available</h3>
                        @else
                            <h3 class="product-subtitle2"><i class="fa fa-times-circle fa-fw"></i> Not in Stock</h3>
                        @endif

                        <div class="rating-box">
                            @for($i = 1; $i <= 5; $i++)
                                <div class="star">
                                    <i class="fa {{ $i <= $productdata->rating() ? 'fa-star' : 'fa-star-o' }}"></i>
                                </div>
                            @endfor
                            <div class="rating-number">{{ $productdata->reviews()->count() }} Reviews</div>
                        </div>

                        <div class="product-description detail-info-entry">
                            {{ Str::limit(strip_tags($productdata->description), 600) }}... 
                            <a id="showmore">Show More</a>
                        </div>

                        <div class="price detail-info-entry">
                            @if($productdata->previous_price)
                                <div class="prev">${{ $productdata->previous_price }}</div>
                            @endif
                            <div class="current">$<span id="price">{{ $productdata->price }}</span></div>
                        </div>

                        @if($productdata->sizes)
                            <div class="size-selector detail-info-entry">
                                <div class="detail-info-entry-title">Size</div>
                                @foreach(explode(',', $productdata->sizes) as $size)
                                    <div class="entry">{{ $size }}</div>
                                @endforeach
                            </div>
                        @endif

                        <div class="quantity-selector detail-info-entry">
                            <div class="detail-info-entry-title">Quantity</div>
                            <div class="entry number-minus">&nbsp;</div>
                            <div class="entry number">1</div>
                            <div class="entry number-plus">&nbsp;</div>
                        </div>

                        <!-- CART FORM -->
                        <div class="detail-info-entry">
                            <form id="cartfrom">
                                {{ csrf_field() }}
                                <input type="hidden" name="uniqueid" value="{{ Session::get('uniqueid', \Illuminate\Support\Str::random(7)) }}">
                                <input type="hidden" name="title" value="{{ $productdata->title }}">
                                <input type="hidden" name="product" value="{{ $productdata->id }}">
                                <input type="hidden" id="size" name="size" value="">
                                <input type="hidden" id="cost" name="cost" value="{{ $productdata->price }}">
                                <input type="hidden" id="quantity" name="quantity" value="1">
                                @if($productdata->stock != 0 || $productdata->stock === null)
                                    <button type="button" class="button style-10 to-cart">Add to cart</button>
                                @else
                                    <button type="button" class="button style-10 to-cart" disabled>Out Of Stock</button>
                                @endif
                            </form>
                        </div>

                        <!-- SHARE BOX -->
                        <div class="share-box detail-info-entry">
                            <div class="a2a_kit a2a_kit_size_32 a2a_default_style">
                                <a class="a2a_dd" href="https://www.geniusocean.com"></a>
                                <a class="a2a_button_facebook"></a>
                                <a class="a2a_button_twitter"></a>
                                <a class="a2a_button_google_plus"></a>
                                <a class="a2a_button_linkedin"></a>
                            </div>
                            <script async src="https://static.addtoany.com/menu/page.js"></script>
                            <div class="title">Share in social media</div>
                        </div>

                    </div>
                </div>

                <div class="clear visible-xs visible-sm"></div>

            </div>
        </div>

        <!-- TABS: Description, Policy, Reviews -->
        <div class="information-blocks">
            <div class="card">
                @if(Session::has('message'))
                    <div class="alert alert-success">{{ Session::get('message') }}</div>
                @endif
                <ul class="nav nav-tabs">
                    <li class="active"><a href="#description" data-toggle="tab">Full Description</a></li>
                    <li><a href="#policy" data-toggle="tab">Return & Policy</a></li>
                    <li><a href="#reviews" data-toggle="tab">Reviews ({{ $productdata->reviews()->count() }})</a></li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="description">{!! $productdata->description !!}</div>
                    <div class="tab-pane" id="policy">{!! $productdata->policy !!}</div>
                    <div class="tab-pane" id="reviews">
                        <h3>Write a Review</h3>
                        <form method="POST" action="{{ route('review.submit') }}">
                            {{ csrf_field() }}
                            <input type="hidden" name="rating" id="rate" value="5">
                            <input type="hidden" name="productid" value="{{ $productdata->id }}">
                            <input type="text" name="name" placeholder="Full Name" class="form-control" required>
                            <input type="email" name="email" placeholder="Your Email" class="form-control" required>
                            <textarea name="review" placeholder="Review Description" class="form-control" rows="6"></textarea>
                            <button type="submit" class="button style-10">Submit Review</button>
                        </form>
                        <hr>
                        <h3>Reviews:</h3>
                        @forelse($reviews as $review)
                            <div class="row rating-row">
                                <div class="col-md-3">
                                    <strong>{{ $review->name }}</strong>
                                    <div class="rating-box">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fa {{ $i <= $review->rating ? 'fa-star' : 'fa-star-o' }}"></i>
                                        @endfor
                                    </div>
                                    <div class="rating-date">{{ $review->review_date }}</div>
                                </div>
                                <div class="col-md-8">{{ $review->review }}</div>
                            </div>
                        @empty
                            <h4>No review has given yet.</h4>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<!-- RELATED PRODUCTS -->
<section class="wow fadeInUp">
    <div class="container">
        <h3>Related Products</h3>
        <hr>
        <div class="row owl-carousel" id="related-products">
            @foreach($relateds as $product)
                @include('partials.product-card', ['product' => $product])
            @endforeach
        </div>
    </div>
</section>

@stop

@section('footer')
<script>
    $('#star1').starrr({
        rating: 5,
        change: function(e, value){
            if (value) {
                $('.your-choice-was').show();
                $('.choice').text(value);
                $('#rate').val(value);
            } else {
                $('.your-choice-was').hide();
            }
        }
    });

    $("#showmore").click(function() {
        $('html, body').animate({
            scrollTop: $("#description").offset().top - 200
        }, 1000);
    });
</script>
@stop
