<?php $__env->startSection('content'); ?>

<!-- SLIDER -->
<section class="go-slider">
    <div id="bootstrap-touch-slider" class="carousel bs-slider fade control-round indicators-line" data-ride="carousel" data-pause="hover" data-interval="5000">

        <div class="carousel-inner" role="listbox">
            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="item <?php echo e($i == 0 ? 'active' : ''); ?>">
                    <img src="<?php echo e(url('/assets/images/sliders/' . $slider->image)); ?>" class="slide-image" alt="<?php echo e($slider->title); ?>">
                    <div class="bs-slider-overlay"></div>
                    <div class="container">
                        <div class="row">
                            <div class="slide-text <?php echo e($slider->text_position); ?>">
                                <h1><?php echo e($slider->title); ?></h1>
                                <p><?php echo e($slider->text); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <a class="left carousel-control" href="#bootstrap-touch-slider" role="button" data-slide="prev">
            <span class="fa fa-angle-left"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="right carousel-control" href="#bootstrap-touch-slider" role="button" data-slide="next">
            <span class="fa fa-angle-right"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
</section>

<!-- SERVICES -->
<section class="wow fadeInUp go-services hideme">
    <div class="row" style="margin-top:70px;">
        <div class="container">
            <div class="col-md-6 col-md-offset-3">
                <div class="section-title">
                    <h2><?php echo e($languages->service_title); ?></h2>
                    <p><?php echo e($languages->service_text); ?></p>
                </div>
            </div>

            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xs-12 col-md-4">
                    <div class="service-list text-center wow fadeInUp">
                        <img src="<?php echo e(url('/assets/images/service/' . $service->icon)); ?>" alt="">
                        <h3><?php echo e($service->title); ?></h3>
                        <p><?php echo e($service->text); ?></p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- CATEGORIES -->
<section class="wow fadeInUp go-categories hideme">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-6 col-md-offset-3">
                <div class="section-title">
                    <h2>Categories</h2>
                    <p>Browse our product categories</p>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4">
                    <h3><?php echo e($main->name); ?></h3>
                    <?php $__currentLoopData = $main->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h5>-- <?php echo e($sub->name); ?></h5>
                        <?php $__currentLoopData = $sub->subChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p>---- <?php echo e($child->name); ?></p>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- PRODUCTS TAB (Features, Latest, Popular) -->
<section class="wow fadeInUp go-products">
    <div class="container">
        <div class="row">
            <div class="card col-md-12">
                <ul class="nav nav-tabs home-tab" role="tablist">
                    <li class="active"><a href="#home" role="tab" data-toggle="tab">Feature Products</a></li>
                    <li><a href="#profile" role="tab" data-toggle="tab">Latest Products</a></li>
                    <li><a href="#messages" role="tab" data-toggle="tab">Popular Products</a></li>
                </ul>

                <div class="tab-content">
                    <!-- FEATURE -->
                    <div role="tabpanel" class="tab-pane fade in active" id="home">
                        <div class="row">
                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make('partials.product-card', ['product' => $product], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- LATEST -->
                    <div role="tabpanel" class="tab-pane fade" id="profile">
                        <div class="row">
                            <?php $__currentLoopData = $latests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make('partials.product-card', ['product' => $product], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- POPULAR -->
                    <div role="tabpanel" class="tab-pane fade" id="messages">
                        <div class="row">
                            <?php $__currentLoopData = $tops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make('partials.product-card', ['product' => $product], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- TESTIMONIALS -->
<section class="wow fadeInUp testimonials hideme">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-6 col-md-offset-3">
                <div class="section-title">
                    <h2><?php echo e($languages->testimonial_title); ?></h2>
                    <p><?php echo e($languages->testimonial_text); ?></p>
                </div>
            </div>
        </div>
        <div class="col-sm-12">
            <div id="customers-testimonials" class="owl-carousel">
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">
                        <div class="shadow-effect">
                            <i class="fa fa-quote-right"></i>
                            <div class="item-details">
                                <p><?php echo e($testimonial->review); ?></p>
                                <h5><?php echo e($testimonial->client); ?></h5>
                                <p><?php echo e($testimonial->designation); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('includes.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>