<!doctype html>
<html class="no-js" lang="zxx">

<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <title>Bfolio - Personal Portfolio HTML Template</title>
   <meta name="description" content="">
   <meta name="viewport" content="width=device-width, initial-scale=1">

   <!-- Place favicon.ico in the root directory -->
   <link rel="shortcut icon" type="image/x-icon" href="assets/img/logo/favicon.png">

   <!-- CSS here -->
   <link rel="stylesheet" href="assets/css/bootstrap.css">
   <link rel="stylesheet" href="assets/css/swiper-bundle.css">
   <link rel="stylesheet" href="assets/css/swiper-gl.css">
   <link rel="stylesheet" href="assets/css/magnific-popup.css">
   <link rel="stylesheet" href="assets/css/font-awesome-pro.css">
   <link rel="stylesheet" href="assets/css/spacing.css">
   <link rel="stylesheet" href="assets/css/main.css">
</head>

<body class="tp-magic-cursor bfolio-light" data-bg-color="#f5f5f5">
   <!--[if lte IE 9]>
      <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
      <![endif]-->

   <!-- Preloader -->
   <div class="preloader">
      <div class="spinner-wrap">
         <div class="preloader-logo">
            <img data-width="140" src="assets/img/logo/logo-2.png" alt="" class="img-fluid">
         </div>
         <div class="spinner"></div>
      </div>
   </div>
   <!-- Preloader End -->

   <!-- Begin magic cursor -->
   <div id="magic-cursor" class="cursor-white-bg">
      <div id="ball"></div>
   </div>
   <!-- End magic cursor -->

   <!-- back to top start -->
   <div class="back-to-top-wrapper">
      <button id="back_to_top" type="button" class="back-to-top-btn">
         <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M11 6L6 1L1 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
               stroke-linejoin="round" />
         </svg>
      </button>
   </div>
   <!-- back to top end -->

   <!--search-form-start -->
   <div class="tp-search-body-overlay"></div>
   <div class="tp-search-form-toggle">
      <div class="container">
         <div class="row mb-70">
            <div class="col-lg-12">
               <div class="tp-search-top d-flex justify-content-between align-items-center">
                  <div class="tp-header-logo">
                     <a class="logo-dark d-none" href="index.html"><img data-width="138" src="assets/img/logo/logo-2.png" alt=""></a>
                     <a class="logo-white" href="index.html"><img data-width="138" src="assets/img/logo/logo.png" alt=""></a>
                  </div>
                  <button class="tp-search-close">
                     <i class="fa-light fa-xmark"></i>
                  </button>
               </div>
            </div>
         </div>
         <div class="row justify-content-center">
            <div class="col-lg-12">
               <div class="tp-search-form">
                  <form action="about-us-light.html#">
                     <div class="tp-search-form-input">
                        <input type="text" placeholder="What are you looking foor?" required>
                        <span class="tp-search-focus-border"></span>
                        <button class="tp-search-form-icon" type="submit">
                           <i class="fa-sharp fa-regular fa-magnifying-glass"></i>
                        </button>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <!-- search-form-end -->

   <!-- tp-offcanvus-area-start -->
   <div class="tp-offcanvas-area">
      <div class="tp-offcanvas">
         <div class="tp-offcanvas-top d-flex align-items-center justify-content-between">
            <div class="tp-header-logo">
               <a class="logo-dark d-none" href="index.html"><img data-width="138" src="assets/img/logo/logo-2.png" alt=""></a>
               <a class="logo-white" href="index.html"><img data-width="138" src="assets/img/logo/logo.png" alt=""></a>
            </div>
            <div class="tp-offcanvas-close-btn">
               <button class="close-btn">
                  <svg width="37" height="38" viewBox="0 0 37 38" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path d="M9.19141 9.80762L27.5762 28.1924" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                     <path d="M9.19141 28.1924L27.5762 9.80761" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                  </svg>
               </button>
            </div>
         </div>
         <div class="tp-offcanvas-content d-none d-xl-block">
            <h3 class="tp-offcanvas-title">Hello There!</h3>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, </p>
         </div>
         <div class="tp-offcanvas-menu d-xl-none">
            <nav></nav>
         </div>
         <div class="tp-offcanvas-gallery d-none d-xl-block">
            <div class="row gx-2">
               <div class="col-md-3 col-3">
                  <div class="tp-offcanvas-gallery-img fix">
                     <a class="popup-image" href="assets/img/offcanvas/offcanvas-1.jpg"><img src="assets/img/offcanvas/offcanvas-1.jpg" alt=""></a>
                  </div>
               </div>
               <div class="col-md-3 col-3">
                  <div class="tp-offcanvas-gallery-img fix">
                     <a class="popup-image" href="assets/img/offcanvas/offcanvas-2.jpg"><img src="assets/img/offcanvas/offcanvas-2.jpg" alt=""></a>
                  </div>
               </div>
               <div class="col-md-3 col-3">
                  <div class="tp-offcanvas-gallery-img fix">
                     <a class="popup-image" href="assets/img/offcanvas/offcanvas-3.jpg"><img src="assets/img/offcanvas/offcanvas-3.jpg" alt=""></a>
                  </div>
               </div>
               <div class="col-md-3 col-3">
                  <div class="tp-offcanvas-gallery-img fix">
                     <a class="popup-image" href="assets/img/offcanvas/offcanvas-4.jpg"><img src="assets/img/offcanvas/offcanvas-4.jpg" alt=""></a>
                  </div>
               </div>
            </div>
         </div>
         <div class="tp-offcanvas-contact">
            <h3 class="tp-offcanvas-title sm">Information</h3>
            <ul>
               <li><a href="tel:1245654">+ 4 20 7700 1007</a></li>
               <li><a href="mailto:hello@aleric.com">hello@aleric.com</a></li>
               <li><a href="about-us-light.html#">Avenue de Roma 158b, Lisboa</a></li>
            </ul>
         </div>
         <div class="tp-offcanvas-social">
            <h3 class="tp-offcanvas-title sm">Follow Us</h3>
            <ul>
               <li>
                  <a href="about-us-light.html#">
                     <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.25 1.5H4.75C2.95507 1.5 1.5 2.95507 1.5 4.75V11.25C1.5 13.0449 2.95507 14.5 4.75 14.5H11.25C13.0449 14.5 14.5 13.0449 14.5 11.25V4.75C14.5 2.95507 13.0449 1.5 11.25 1.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M10.6016 7.5907C10.6818 8.13166 10.5894 8.68414 10.3375 9.16955C10.0856 9.65497 9.68711 10.0486 9.19862 10.2945C8.71014 10.5404 8.15656 10.6259 7.61663 10.5391C7.0767 10.4522 6.57791 10.1972 6.19121 9.81055C5.80451 9.42385 5.54959 8.92506 5.46271 8.38513C5.37583 7.8452 5.46141 7.29163 5.70728 6.80314C5.95315 6.31465 6.34679 5.91613 6.83221 5.66425C7.31763 5.41238 7.87011 5.31998 8.41107 5.4002C8.96287 5.48202 9.47372 5.73915 9.86817 6.1336C10.2626 6.52804 10.5197 7.0389 10.6016 7.5907Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M11.5742 4.42578H11.5842" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                     </svg>
                  </a>
               </li>
               <li>
                  <a href="about-us-light.html#">
                     <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M2.50589 12.7494C4.57662 16.336 9.16278 17.5648 12.7494 15.4941C14.2113 14.65 15.2816 13.388 15.8962 11.9461C16.7895 9.85066 16.7208 7.37526 15.4941 5.25063C14.2674 3.12599 12.1581 1.82872 9.89669 1.55462C8.34063 1.366 6.71259 1.66183 5.25063 2.50589C1.66403 4.57662 0.435172 9.16278 2.50589 12.7494Z" stroke="currentColor" stroke-width="1.5" />
                        <path d="M12.7127 15.4292C12.7127 15.4292 12.0086 10.4867 10.5011 7.87559C8.99362 5.26451 5.28935 2.57155 5.28935 2.57155M5.68449 15.6124C6.79553 12.2606 12.34 8.54524 16.3975 9.43537M12.311 2.4082C11.1953 5.72344 5.75732 9.38453 1.71875 8.58915" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                     </svg>
                  </a>
               </li>
               <li>
                  <a href="about-us-light.html#">
                     <svg width="18" height="11" viewBox="0 0 18 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 5.5715H6.33342C7.62867 5.5715 8.61917 6.56199 8.61917 7.85725C8.61917 9.15251 7.62867 10.143 6.33342 10.143H1.76192C1.30477 10.143 1 9.83823 1 9.38108V1.76192C1 1.30477 1.30477 1 1.76192 1H5.5715C6.86676 1 7.85725 1.99049 7.85725 3.28575C7.85725 4.58101 6.86676 5.5715 5.5715 5.5715H1Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"></path>
                        <path d="M10.9062 7.09454H17.0016C17.0016 5.41832 15.6301 4.04688 13.9539 4.04688C12.2777 4.04688 10.9062 5.41832 10.9062 7.09454ZM10.9062 7.09454C10.9062 8.77076 12.2777 10.1422 13.9539 10.1422H15.2492" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M16.1125 1.44434H11.668" stroke="currentColor" stroke-width="1.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                     </svg>
                  </a>
               </li>
               <li>
                  <a href="about-us-light.html#">
                     <svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12.75 13H5.25C3 13 1.5 11.5 1.5 9.25V4.75C1.5 2.5 3 1 5.25 1H12.75C15 1 16.5 2.5 16.5 4.75V9.25C16.5 11.5 15 13 12.75 13Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M8.70676 5.14837L10.8006 6.40465C11.5543 6.90716 11.5543 7.66093 10.8006 8.16344L8.70676 9.41972C7.86923 9.92224 7.19922 9.50348 7.19922 8.5822V6.06964C7.19922 4.98086 7.86923 4.64585 8.70676 5.14837Z" fill="currentColor" />
                     </svg>
                  </a>
               </li>
            </ul>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- tp-offcanvus-area-end -->

   <header>

      <!-- tp-header-area-start -->
      <div id="header-sticky" class="tp-header-area bf-header-3-style tp-header-2-spacing mt-20 tp-transparent tp-header-spacing">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xl-2 col-lg-3 col-md-4 col-6">
                  <div class="tp-header-logo">
                     <a class="logo-dark d-none" href="index.html"><img data-width="138" src="assets/img/logo/logo-2.png" alt=""></a>
                     <a class="logo-white" href="index.html"><img data-width="138" src="assets/img/logo/logo.png" alt=""></a>
                  </div>
               </div>
               <div class="col-lg-6 d-none d-xl-block">
                  <div class="tp-main-menu tp-main-menu-2 text-end mr-85">
                    <nav class="tp-mobile-menu-active">
                        <ul>
                           <li class="has-dropdown position-static">
                              <a href="index.php">
                                 <span class="explore-text" data-text="Home">Home</span>
                             </a>
                             
                           </li>
                         
                         
                           <li>
                              <a href="contact.php">
                                 <span class="explore-text" data-text="Contact">Contact</span>
                              </a>
                             
                           </li>
                           <li>
                              <a href="Products.php">
                                 <span class="explore-text" data-text="Products">Products</span>
                              </a>
                              
                             
                           </li><li>
                              <a href="services.php">
                                 <span class="explore-text" data-text="Infrastructure">Infrastructure</span>
                              </a>
                             
                           </li><li>
                              <a href="contact-light.html">
                                 <span class="explore-text" data-text="Contact">Contact</span>
                              </a>
                             
                           </li>
                           <li>
                              <a href="categories.php">
                                 <span class="explore-text" data-text="categories">categories</span>
                              </a>
                             
                           </li>
                           
                        </ul>
                     </nav>
                  </div>
               </div>
               <div class="col-xl-4 col-lg-9 col-md-8 col-6">
                  <div class="tp-header-right d-flex justify-content-end">
                     <button class="tp-header-search tp-search-click">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                           <path d="M9.00004 17.0001C13.4183 17.0001 17.0001 13.4184 17.0001 9.00006C17.0001 4.58176 13.4183 1.00002 9.00004 1.00002C4.58174 1.00002 1 4.58176 1 9.00006C1 13.4184 4.58174 17.0001 9.00004 17.0001Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                           <path d="M19.0004 18.9999L14.6504 14.6499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                     </button>
                     <a href="contact-light.html" class="tp-btn d-none d-md-inline-flex align-items-center ml-30">
                        <span>
                           <span class="text-1">Let’s Talk</span>
                           <span class="text-2">Let’s Talk</span>
                        </span>
                     </a>
                     <button class="tp-header-menu-btn tp-menu-bar ml-10">
                        <span></span>
                        <span></span>
                        <span></span>
                     </button>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- tp-header-area-end -->

   </header>

   <div id="smooth-wrapper">
      <div id="smooth-content">
         <main>

            <!-- bf-about-area-start -->
            <div class="bf-about-area bf-about-us-spacing">
               <div class="container">
                  <div class="row">
                     <div class="col-12">
                        <div class="bf-about-us-hero">
                           <h2 class="bf-about-us-title mb-30">Fueling Minds<br> Inspiring Designs..</h2>
                           <div class="bf-about-us-dec-wrap">
                              <div class="row">
                                 <div class="col-lg-3 col-md-4">
                                    <span class="bf-about-us-subtitle">About Us
                                       <svg class="ml-20" width="81" height="9" viewBox="0 0 81 9" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <rect y="4" width="80" height="1" fill="currentColor" />
                                          <path d="M77 7.96366L80.5 4.48183L77 1" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                       </svg>
                                    </span>
                                 </div>
                                 <div class="col-lg-7 col-md-8">
                                    <p class="bf-about-us-dec">An independent web design and branding agency
                                    in Manchester set up in 2012 who care, build relationships,
                                    have industry experience, and win awards.</p>
                                 </div>
                              </div>
                           </div>
                           <div class="bf-about-us-gif text-center pt-40">
                              <img src="videos/bfolio/about.gif" alt="">
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- bf-about-area-end -->

            <!-- bf-about-video-area-start -->
            <div class="bf-about-us-video">
               <video loop="" muted="" autoplay="" playsinline="">
                  <source src="videos/bfolio/video-2.mp4" type="video/mp4">
               </video>
            </div>
            <!-- bf-about-video-area-end -->

            <!-- bf-about-area-start -->
            <div class="bf-about-area pt-140 pb-130">
               <div class="container">
                  <div class="row">
                     <div class="col-lg-3">
                        <div class="bf-about-3-subtile mb-20">
                           <span>About us</span>
                        </div>
                     </div>
                     <div class="col-lg-9">
                        <div class="bf-about-3-title-wrap mb-20">
                           <h2 class="bf-about-3-title reveal-text">An independent web design and
                              branding agency in Manchester set up
                              2010 who care, build relationships, have
                              industry experience, and win awards.</h2>
                        </div>
                     </div>
                     <div class="col-lg-3 col-md-5 col-sm-5">
                        <div class="bf-about-3-thumb mb-30">
                           <img src="assets/img/update/about/abour-3/thumb.jpg" alt="">
                        </div>
                     </div>
                     <div class="col-lg-4 col-md-7 col-sm-7">
                        <div class="bf-about-3-thumb-2 pt-60 ml-50 mb-30">
                           <img src="assets/img/update/about/abour-3/thumb-2.jpg" alt="">
                        </div>
                     </div>
                     <div class="col-lg-5">
                        <div class="bf-about-3-info-wrap pt-90 ml-35">
                           <div class="bf-about-3-avatar">
                              <img class="mb-15" src="assets/img/update/about/abour-3/avatar.png" alt="">
                              <p>Driven by a passion for innovation, we specialize in
                              delivering top-quality design solutions</p>
                           </div>
                           <div class="bf-about-3-count-wrap">
                              <div class="row">
                                 <div class="col-md-6">
                                    <div class="bf-about-3-count-item mb-30">
                                       <h2 class="bf-about-3-count-title">98%</h2>
                                       <span>Clients Satisfied and <br> Repeating</span>
                                    </div>
                                 </div>
                                 <div class="col-md-6">
                                    <div class="bf-about-3-count-item mb-30">
                                       <h2 class="bf-about-3-count-title">125+</h2>
                                       <span>Projects Completed in<br> 24 Countries</span>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- bf-about-area-end -->

            <!-- bf-team-area-start -->
            <div class="bf-team-area pt-160 pb-130" data-bg-color="#fff">
               <div class="container">
                  <div class="row">
                     <div class="col-lg-6">
                        <div class="bf-team-content-wrap mr-110 mb-30">
                           <div class="bf-team-title-wrap mb-30">
                              <span class="bf-team-subtitle d-inline-block mb-10">Who stay behind</span>
                              <h2 class="tp-section-tittle">Global executive leadership</h2>
                           </div>
                           <div class="bf-team-info">
                              <h4 class="mb-15">Be part of our mission</h4>
                              <p class="mb-40">If you’re ready to create and collaborate,<br>
                                 we’d love to hear from you.</p>
                              <div class="bf-team-contact-info d-flex align-items-center">
                                 <a href="contact-light.html" class="tp-btn tp-btn-xl mr-20 d-inline-flex align-items-center">
                                    <span>
                                       <span class="text-1">Contact Us</span>
                                       <span class="text-2">Contact Us</span>
                                    </span>
                                 </a>
                                 <div class="bf-team-contact d-flex align-items-center">
                                    <span class="mr-20">
                                       <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M12.496 6.99986C12.152 6.99986 11.88 6.71986 11.88 6.38386C11.88 6.08786 11.584 5.47187 11.088 4.93587C10.6 4.41587 10.064 4.11188 9.616 4.11188C9.272 4.11188 9 3.83188 9 3.49588C9 3.15988 9.28 2.87988 9.616 2.87988C10.416 2.87988 11.256 3.31188 11.992 4.08788C12.68 4.81587 13.12 5.71987 13.12 6.37586C13.12 6.71986 12.84 6.99986 12.496 6.99986Z" fill="white" />
                                          <path d="M15.3818 6.99996C15.0378 6.99996 14.7658 6.71996 14.7658 6.38396C14.7658 3.54398 12.4538 1.23999 9.62186 1.23999C9.27786 1.23999 9.00586 0.959994 9.00586 0.623996C9.00586 0.287998 9.27786 0 9.61386 0C13.1338 0 15.9978 2.86398 15.9978 6.38396C15.9978 6.71996 15.7178 6.99996 15.3818 6.99996Z" fill="white" />
                                          <path d="M7.83195 9.76794L5.21597 12.3839C4.92797 12.1279 4.64797 11.8639 4.37597 11.5919C3.55198 10.7599 2.80798 9.88794 2.14399 8.97594C1.48799 8.06395 0.959994 7.15196 0.575996 6.24796C0.191999 5.33597 0 4.46397 0 3.63198C0 3.08798 0.0959993 2.56798 0.287998 2.08799C0.479997 1.59999 0.783995 1.15199 1.20799 0.751995C1.71999 0.247999 2.27999 0 2.87198 0C3.09598 0 3.31998 0.0479998 3.51998 0.143999C3.72798 0.239999 3.91198 0.383998 4.05597 0.591996L5.91196 3.20798C6.05596 3.40798 6.15996 3.59198 6.23196 3.76798C6.30396 3.93598 6.34396 4.10397 6.34396 4.25597C6.34396 4.44797 6.28796 4.63997 6.17596 4.82397C6.07196 5.00797 5.91996 5.19997 5.72796 5.39197L5.11997 6.02396C5.03197 6.11196 4.99197 6.21596 4.99197 6.34396C4.99197 6.40796 4.99997 6.46396 5.01597 6.52796C5.03997 6.59196 5.06397 6.63996 5.07997 6.68796C5.22397 6.95196 5.47197 7.29596 5.82396 7.71195C6.18396 8.12795 6.56796 8.55195 6.98396 8.97594C7.27195 9.25594 7.55195 9.52794 7.83195 9.76794Z" fill="white" />
                                          <path d="M15.978 13.0641C15.978 13.2881 15.938 13.5201 15.858 13.7441C15.834 13.8081 15.81 13.8721 15.778 13.9361C15.642 14.2241 15.466 14.4961 15.234 14.752C14.842 15.184 14.41 15.496 13.922 15.696C13.914 15.696 13.906 15.704 13.898 15.704C13.426 15.896 12.914 16 12.362 16C11.546 16 10.674 15.808 9.75401 15.416C8.83401 15.024 7.91402 14.4961 7.00203 13.8321C6.69003 13.6001 6.37803 13.3681 6.08203 13.1201L8.69801 10.5041C8.92201 10.6721 9.12201 10.8001 9.29001 10.8881C9.33001 10.9041 9.37801 10.9281 9.43401 10.9521C9.49801 10.9761 9.56201 10.9841 9.63401 10.9841C9.77001 10.9841 9.87401 10.9361 9.96201 10.8481L10.57 10.2481C10.77 10.0481 10.962 9.89608 11.146 9.80008C11.33 9.68808 11.514 9.63208 11.714 9.63208C11.866 9.63208 12.026 9.66408 12.202 9.73608C12.378 9.80808 12.562 9.91208 12.762 10.0481L15.41 11.9281C15.618 12.0721 15.762 12.2401 15.85 12.4401C15.93 12.6401 15.978 12.8401 15.978 13.0641Z" fill="white" />
                                       </svg>
                                    </span>
                                    <a href="tel:+99926542563">+999 2654 2563</a>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="col-lg-6">
                        <div class="bf-team-item-wrap">
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-6">
                                 <div class="bf-team-item mb-30">
                                    <div class="bf-team-thumb p-relative">
                                       <a href="about-us-light.html#">
                                          <img class="w-100" src="assets/img/update/team/thumb.jpg" alt="">
                                       </a>
                                       <h4 class="bf-team-content-title"><a class="common-underline" href="about-us-light.html#">Crsitopher<br> Miller</a></h4>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-6">
                                 <div class="bf-team-item mb-30">
                                    <div class="bf-team-thumb p-relative">
                                       <a href="about-us-light.html#">
                                          <img class="w-100" src="assets/img/update/team/thumb-2.jpg" alt="">
                                       </a>
                                       <h4 class="bf-team-content-title"><a class="common-underline" href="about-us-light.html#">Bramwell<br> Cutter</a></h4>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-6">
                                 <div class="bf-team-item mb-30">
                                    <div class="bf-team-thumb p-relative">
                                       <a href="about-us-light.html#">
                                          <img class="w-100" src="assets/img/update/team/thumb-3.jpg" alt="">
                                       </a>
                                       <h4 class="bf-team-content-title"><a class="common-underline" href="about-us-light.html#">Thayer<br> Juno</a></h4>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-6">
                                 <div class="bf-team-item mb-30">
                                    <div class="bf-team-thumb p-relative">
                                       <a href="about-us-light.html#">
                                          <img class="w-100" src="assets/img/update/team/thumb-4.jpg" alt="">
                                       </a>
                                       <h4 class="bf-team-content-title"><a class="common-underline" href="about-us-light.html#">James<br> Smith</a></h4>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- bf-team-area-end -->

            <!-- bf-banner-area-start -->
            <div class="bf-banner-area bf-banner-spacing bg-position" data-background="videos/baner.png">
               <div class="container">
                  <div class="row">
                     <div class="col-lg-5">
                        <div class="bf-banner-subtitle mb-40 mt-100">
                           <span>Check quote</span>
                        </div>
                     </div>
                     <div class="col-lg-7">
                        <div class="bf-banner-content mb-40">
                           <span class="d-inline-block mb-40">
                              <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <path d="M39.8924 59.5V40.9324C39.8924 40.6563 39.6686 40.4324 39.3924 40.4324H20.3922C20.116 40.4324 19.8922 40.2086 19.8922 39.9324V20.6081C19.8922 20.332 19.6683 20.1081 19.3922 20.1081H11.0405C10.5957 20.1081 10.3723 19.5709 10.686 19.2555L28.9902 0.852602C29.3039 0.537233 29.0805 0 28.6357 0H0.5C0.223858 0 0 0.223859 0 0.500002V40.2229C0 40.3569 0.0538138 40.4854 0.149367 40.5794L19.7462 59.8565C19.8397 59.9484 19.9657 60 20.0969 60H39.3924C39.6686 60 39.8924 59.7761 39.8924 59.5Z" fill="white" />
                                 <path d="M59.3912 0H32.4042C31.9653 0 31.7393 0.52506 32.0411 0.843767L49.6868 19.4806C49.9886 19.7993 49.7626 20.3243 49.3237 20.3243H40.6072C40.331 20.3243 40.1072 20.5482 40.1072 20.8243V39.8893C40.1072 40.0288 40.1655 40.1619 40.268 40.2566L59.052 57.6034C59.3723 57.8991 59.8912 57.672 59.8912 57.236V0.5C59.8912 0.223858 59.6674 0 59.3912 0Z" fill="white" />
                              </svg>
                           </span>
                           <h4 class="bf-banner-title mb-45">“Working with Bfolio was different. They
                              didn’t just give us a new logo or a clean
                              website, they gave us a brand we
                              can grow with.</h4>
                           <div class="bf-banner-author-info">
                              <h5 class="mb-0">Harun Or Rashid</h5>
                              <span>Developer</span>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- bf-banner-area-end -->

            <!-- tp-text-slider-area-start -->
            <div class="tp-text-slider-area bf-text-slider-style pt-155" data-bg-color="#fff">
               <div class="tp-text-slide-top">
                  <div class="swiper-container tp-text-slide-active mb-10">
                     <div class="swiper-wrapper slide-transtion">
                        <div class="swiper-slide">
                           <div class="tp-text-content">
                              <span>Award & recognitions</span>
                           </div>
                        </div>
                        <div class="swiper-slide">
                           <div class="tp-text-content">
                              <span>Award & recognitions</span>
                           </div>
                        </div>
                        <div class="swiper-slide">
                           <div class="tp-text-content">
                              <span>Award & recognitions</span>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="tp-text-slide-bottom">
                  <div class="swiper-container tp-text-slide-active" dir="rtl">
                     <div class="swiper-wrapper slide-transtion">
                        <div class="swiper-slide">
                           <div class="tp-text-content">
                              <span>Award & recognitions</span>
                           </div>
                        </div>
                        <div class="swiper-slide">
                           <div class="tp-text-content">
                              <span>Award & recognitions</span>
                           </div>
                        </div>
                        <div class="swiper-slide">
                           <div class="tp-text-content">
                              <span>Award & recognitions</span>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- tp-text-slider-area-end -->

            <!-- award area start -->
            <div class="fix p-relative z-index-4 pt-85 title-box pb-160" data-bg-color="#fff">
               <div class="container">
                  <div class="design-award-wrap">
                     <div class="row row-cols-1">
                        <div class="col">
                           <div class="design-award-item hover-reveal-item active p-relative">
                              <div class="design-award-content design-award-content-xs d-flex align-items-center justify-content-between">
                                 <h4>A' Design Awards & competition</h4>
                                 <span>Silver Medal</span>
                              </div>
                              <div class="design-award-reveal-img" data-background="assets/img/award/award.jpg"></div>
                           </div>
                        </div>
                        <div class="col">
                           <div class="design-award-item hover-reveal-item active p-relative">
                              <div class="design-award-content design-award-content-xs d-flex align-items-center justify-content-between">
                                 <h4>AWWWARDS</h4>
                                 <span>2X - Honnerable </span>
                              </div>
                              <div class="design-award-reveal-img" data-background="assets/img/award/award-2.jpg"></div>
                           </div>
                        </div>
                        <div class="col">
                           <div class="design-award-item hover-reveal-item active p-relative">
                              <div class="design-award-content design-award-content-xs d-flex align-items-center justify-content-between">
                                 <h4>CSS Design Awards</h4>
                                 <span>2X - Website of the day</span>
                              </div>
                              <div class="design-award-reveal-img" data-background="assets/img/award/award-3.jpg"></div>
                           </div>
                        </div>
                        <div class="col">
                           <div class="design-award-item hover-reveal-item active p-relative">
                              <div class="design-award-content design-award-content-xs d-flex align-items-center justify-content-between">
                                 <h4>2X - Website of the day</h4>
                                 <span>2X - Website of the day</span>
                              </div>
                              <div class="design-award-reveal-img" data-background="assets/img/award/award-4.jpg"></div>
                           </div>
                        </div>
                        <div class="col">
                           <div class="design-award-item hover-reveal-item active p-relative">
                              <div class="design-award-content design-award-content-xs d-flex align-items-center justify-content-between">
                                 <h4>CSS Reels</h4>
                                 <span>Featured of the day</span>
                              </div>
                              <div class="design-award-reveal-img" data-background="assets/img/award/award-5.jpg"></div>
                           </div>
                        </div>
                        <div class="col">
                           <div class="design-award-item hover-reveal-item active p-relative">
                              <div class="design-award-content design-award-content-xs d-flex align-items-center justify-content-between">
                                 <h4>Web Gurus</h4>
                                 <span>2X - Guru of the day</span>
                              </div>
                              <div class="design-award-reveal-img" data-background="assets/img/award/award-6.jpg"></div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- award area end -->

            <!-- instagram text area start -->
            <div class="bf-instagram-area bf-instagram-ptb text-center">
               <div class="bf-instagram-thumb-wrap p-relative">
                  <div class="bf-instagram-thumb-inner-1 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-1.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-2 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-2.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-3 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-3.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-4 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-4.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-5 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-5.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-6 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-6.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-7 d-none d-xl-block">
                     <img src="assets/img/update/instagram/insta-inner-7.jpg" alt="">
                  </div>
                  <div class="bf-instagram-thumb-inner-8 d-none d-xl-block">
                     <a href="about-us-light.html#"><i class="fa-brands fa-instagram"></i></a>
                  </div>
                  <div class="bf-instagram-thumb">
                     <img src="assets/img/update/instagram/insta-1.jpg" alt="">
                  </div>
                  <div class="bf-instagram-content-wrap text-start">
                     <div class="bf-instagram-title-box">
                        <span class="bf-instagram-subtitle">INSTAGRAM</span>
                        <h4 class="bf-instagram-title">@likoagency</h4>
                     </div>
                     <div class="bf-instagram-content">
                        <p>Become a part of our stories! <br> Join the adventure.</p>
                        <a href="about-us-light.html#" class="tp-btn d-inline-flex align-items-center">
                           <span>
                              <span class="text-1">Follow Us</span>
                              <span class="text-2">Follow Us</span>
                           </span>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
            <!-- instagram text area end -->

         </main>

         <footer class="bf-footer-topspacing">
      
            <div class="tp-footer-area  bf-footer-2-wrap pt-155" data-bg-color="#000">
               <div class="container">
                  <div class="tp-footer-middle mb-30">
                     <div class="row">
                        <div class="col-xxl-5 col-xl-4 col-lg-6 col-md-6 col-sm-6">
                           <div class="tp-footer-widget mb-40">
                              <h5 class="tp-footer-tittle mb-15">Stay connected</h5>
                              <a class="tp-footer-email" href="mailto:help@gmail.com">help@gmail.com</a>
                           </div>
                        </div>
                        <div class="col-xxl-2 col-xl-3 col-lg-6 col-md-6 col-sm-6">
                           <div class="tp-footer-widget mb-40">
                              <h5 class="tp-footer-tittle mb-15">London</h5>
                              <a class="tp-footer-link" href="about-us-light.html#">Germany 785 15h Street<br> Office 478 Berlin</a>
                           </div>
                        </div>
                        <div class="col-xxl-2 col-xl-2 col-lg-6 col-md-6 col-sm-6">
                           <div class="tp-footer-widget ml-40  p-relative mb-40">
                              <h5 class="tp-footer-tittle mb-15">Contact</h5>
                              <div>
                                 <a class="tp-footer-link" href="tel:+999236542654">+999 23654 2654</a>
                              </div>
                              <div>
                                 <a class="tp-footer-link" href="mailto:bfolio@help.com">bfolio@help.com</a>
                              </div>
                           </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-6">
                           <div class="tp-footer-widget ml-80 p-relative mb-40">
                              <h5 class="tp-footer-tittle mb-30">Social media</h5>
                              <div class="tp-footer-social mb-70 d-flex">
                                 <span><a href="about-us-light.html#"><i class="fa-brands fa-instagram"></i></a></span>
                                 <span><a href="about-us-light.html#"><i class="fa-brands fa-dribbble"></i></a></span>
                                 <span><a href="about-us-light.html#"><i class="fa-brands fa-behance"></i></a></span>
                                 <span><a href="about-us-light.html#"><i class="fa-brands fa-youtube"></i></a></span>
                              </div>
                           </div>
                        </div>
                        <div class="col-12">
                           <div class="tp-hero-bigtext pt-40">
                              <h2 class="d-flex">Bf <span class="p-relative shape-2">o
                                 <svg width="121" height="59" viewBox="0 0 121 59" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M73.7057 0.781014L120.09 58.3117L67.9817 23.5732L0.309197 28.2302L73.7057 0.781014Z" fill="currentColor" />
                                 </svg>
                              </span> lio <span class="shape">@</span></h2>
                           </div>
                           <div class="tp-footer-copyright pb-15 text-center">
                              <p>© 2025 <a href="about-us-light.html#">Bfolio.</a> All rights reserved.</p>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>

         </footer>    

      </div>
   </div>



   <!-- JS here -->
   <script src="assets/js/vendor/jquery.js"></script>
   <script src="assets/js/bootstrap-bundle.js"></script>
   <script src="assets/js/plugin.js"></script>
   <script src="assets/js/split-type.js"></script>
   <script src="assets/js/swiper-bundle.js"></script>
   <script src="assets/js/swiper-gl.js"></script>
   <script src="assets/js/magnific-popup.js"></script>
   <script src="assets/js/nice-select.js"></script>
   <script src="assets/js/purecounter.js"></script>
   <script src="assets/js/ajax-form.js"></script>
   <script src="assets/js/slider-init.js"></script>
   <script src="assets/js/main.js"></script>
   <script src="assets/js/tp-cursor.js"></script>
</body>

</html>