<!doctype html>
<html lang="en">

<head>
    <title>Marble Manufacturer &amp; Supplier in Delhi NCR | Jain Marble Centre </title>
    <meta name="description"
        content="Leading marble manufacturer &amp; supplier in Delhi NCR. Explore our wide range of premium marble. Quality &amp; reliability guaranteed by Jain Marble.">
    <meta name="keywords"
        content="Jain Marble, Jain Marble Centre, Marble Manufacturer in Delhi, marble supplier in delhi,">
    <!-- Canonical Tag -->
    <link rel="canonical" href="https://jainmarble.com/">

    <!-- Open Graph Tags -->
    <meta property="og:title" content="Marble Manufacturer &amp; Supplier in Delhi NCR | Jain Marble Centre">
    <meta property="og:description"
        content="Leading marble manufacturer &amp; supplier in Delhi NCR. Explore our wide range of premium marble. Quality &amp; reliability guaranteed by Jain Marble.">
    <meta property="og:url" content="https://jainmarble.com/">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://jainmarble.com/assets/jmc_data/logo/small icon.png">

    <!-- Twitter Card Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Marble Manufacturer &amp; Supplier in Delhi NCR | Jain Marble Centre">
    <meta name="twitter:description"
        content="Leading marble manufacturer &amp; supplier in Delhi NCR. Explore our wide range of premium marble. Quality &amp; reliability guaranteed by Jain Marble.">
    <meta name="twitter:image" content="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <meta name="twitter:site" content="@jainmarble">

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Marble Manufacturer & Supplier in Delhi NCR | Jain Marble</title>
    <meta name="description" content="Himgange Heritage, Rishikesh">
    <meta name="author" content="@jainmarble">
    <meta name="robots" content="index, follow">

    <!-- favicon icon -->
    <link rel="shortcut icon" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <link rel="apple-touch-icon" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <link rel="android-chrome" sizes="192x192" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <link rel="favicon" sizes="32x32" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <meta name="google-site-verification" content="wEgKDvNGOZFSeJU2mJXEj3ud0xq8Rxig9YzbldhRCsM" />


    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&amp;display=swap"
        rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400..900;1,400..900&amp;display=swap"
        rel="stylesheet">

    <!-- Plugins -->
    <!-- Font Awesome icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-p1Cm/3S1hYaTK4X6P6V+M3m8Z2aV5/1cXp6qEnhygI3u+cYMCScDZBzLDKCvD+zCMpjk5mx1YjQXKXTcWnM2dg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://jainmarble.com/assets/css/plugins.css">

    <!-- Core Style Css -->
    <link rel="stylesheet" href="https://jainmarble.com/assets/css/style.css">
    <link rel="stylesheet" type="text/css" href="https://jainmarble.com/assets/css/base.css" />

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-5YVM6BVCFG"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag() { dataLayer.push(arguments); }
        gtag('js', new Date());

        gtag('config', 'G-5YVM6BVCFG');
    </script>

</head>

<body class="marketing-agency freelancer">



    <!-- ==================== Start Loading ==================== -->

    <!-- <div class="loader-wrap">
        <svg viewBox="0 0 1000 1000" preserveAspectRatio="none">
            <path id="svg" d="M0,1005S175,995,500,995s500,5,500,5V0H0Z"></path>
        </svg>

        <div class="loader-wrap-heading">
            <div class="load-text">
                <span>L</span>
                <span>o</span>
                <span>a</span>
                <span>d</span>
                <span>i</span>
                <span>n</span>
                <span>g</span>
            </div>
        </div>
    </div> -->

    <!-- ==================== End Loading ==================== -->


    <!--<div class="cursor"></div>-->
    <div class="blur-div"></div>


    <!-- ==================== Start progress-scroll-button ==================== -->

    <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <!-- ==================== End progress-scroll-button ==================== -->



    <!-- ==================== Start Navbar ==================== -->

    <nav class="navbar navbar-expand-lg">
        <div class="container o-hidden">

            <!-- Logo -->
            <a class="logo w-160px" href="index.php">
                <img src="https://jainmarble.com/assets/jmc_data/logo/JMC-mail-logo.png" alt="logo">
            </a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="icon-bar"><i class="fas fa-bars"></i></span>
            </button>

            <!-- navbar links -->
            <div class="collapse navbar-collapse justify-content-center" id="navbarSupportedContent">
                <ul class="navbar-nav">



                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/"><span class="rolling-text">Home</span></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/about-us"><span
                                class="rolling-text">About</span></a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/why-choose-us"><span class="rolling-text">Why
                                Choose Us</span></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/our-categories"><span
                                class="rolling-text">Product</span></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/showroom"><span
                                class="rolling-text">Showroom</span></a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/catalogue"><span
                                class="rolling-text">Catalogue</span></a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/blog.php"><span
                                class="rolling-text">Blogs</span></a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" href="https://jainmarble.com/contact-us"><span
                                class="rolling-text">Contact</span></a>
                    </li>
                </ul>
            </div>

            <div class="contact-button">
                <a href="https://jainmarble.com/contact-us" class="butn border-radius-5px">
                    <span class="text">Let's contact</span>
                </a>
            </div>
        </div>
    </nav>

    <!-- ==================== End Navbar ==================== -->


    <div id="smooth-wrapper">


        <div id="smooth-content">

            <main class="o-hidden">



                <!-- ==================== Start Header ==================== -->


                <!--<header class="pg-hero pt-80px bg-img" data-background="assets/imgs/pattern-bg.webp">-->


                <!--      <img src="https://aimstorms.com/JMC/assets/jmc_data/Catalogue/main blog banner copy cc 2.webp" class="img-fluid" alt="">-->
                <!--        </header>-->

                <!-- ==================== End Header ==================== -->



                <!-- ==================== Start Portfolio ==================== -->

                <section class="work-style3 pt-0">
                    <style>
                        /* Scoped only to this section */
                        .work-style3 .hero-content {
                            text-align: center;
                            padding: 48px 16px 8px;
                        }

                        .work-style3 .hero-title {
                            font-size: clamp(32px, 6vw, 86px);
                            line-height: 1.1;
                            font-weight: 800;
                            letter-spacing: 2px;
                            margin: 0 0 14px;
                        }

                        .work-style3 .hero-subtitle {
                            max-width: 920px;
                            margin: 0 auto;
                            font-size: clamp(12px, 1.6vw, 16px);
                            opacity: .8;
                            letter-spacing: .5px;
                            text-transform: uppercase;
                        }

                        .border-radius-15px {
                            border-radius: 15px;
                        }

                        .h-450px {
                            height: 450px;
                        }

                        .o-hidden {
                            overflow: hidden;
                        }

                        .fit-img img {
                            width: 100%;
                            height: 100%;
                            object-fit: cover;
                            display: block;
                        }

                        /* ✅ Center align work items */
                        .work-style3 .item {
                            margin-left: auto;
                            margin-right: auto;
                        }

                        /* Style for buttons */
                        .btn-style {
                            font-family: 'Glacial Indifference', sans-serif;
                            background-color: #000;
                            color: #fff;
                            border: none;
                            padding: 10px 20px;
                            font-size: 16px;
                            text-transform: uppercase;
                            cursor: pointer;
                            border-radius: 5px;
                            letter-spacing: 1px;
                            transition: background-color 0.3s ease;
                        }

                        .btn-style:hover {
                            background-color: #444;
                        }
                    </style>

                    <div class="container">
                        <div class="row md-marg">
                            <!-- FIRST ITEM now uses video (same size/dimensions) -->
                            <div class="col-lg-12" style="margin-top:50px;">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <video
                                            src="https://aimstorms.com/JMC/assets/jmc_data/Catalogue/new/product video v2.mp4"
                                            autoplay muted loop playsinline
                                            style="width:100%; height:100%; object-fit:cover; display:block;">
                                        </video>
                                    </div>

                                    <div class="hero-content">
                                        <h1 class="hero-title">CRAFTED GRACE</h1>
                                        <p class="hero-subtitle"
                                            style=" font-family: 'Glacial Indifference', sans-serif;">
                                            Inspired by the finest quarries, our marbles reflect the perfect balance of
                                            strength and sophistication. Each slab is a masterpiece, crafted to elevate
                                            architecture with a quiet sense of grandeur.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- ✅ CENTER THE GRID BELOW -->

                        <div class="row md-marg justify-content-center text-center">



                            <!-- ROW TYPE A: 7 LEFT + 3 RIGHT -->
                            <div class="col-lg-7">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <img src="https://i.pinimg.com/736x/40/14/0e/40140edbb900947faed2dff5fb0260e7.jpg"
                                            alt="The Timeless Classics">
                                    </div>
                                    <div class="cont mt-20px d-flex align-items-center justify-content-between">
                                        <a href="https://jainmarble.com/products/The-Timeless-Classics"><button
                                                class="btn-style">The Timeless Classics</button></a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-3">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <img src="https://jainmarble.com/image/catalog/categories/01 right.webp"
                                            alt="The Timeless Classics">
                                    </div>
                                </div>
                            </div>




                            <!-- ROW TYPE B: 3 LEFT + 7 RIGHT -->
                            <div class="col-lg-3">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <img src="https://jainmarble.com/image/catalog/categories/02 right side.webp"
                                            alt="The Designer Collection">
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-7">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <img src="https://as1.ftcdn.net/v2/jpg/07/10/59/64/1000_F_710596424_7KInOTJOEhIc5hxY5ewiONacE2gYaQdy.jpg"
                                            alt="The Designer Collection">
                                    </div>
                                    <div class="cont mt-20px d-flex align-items-center justify-content-between">
                                        <a href="https://jainmarble.com/products/The-Designer-Collection"><button
                                                class="btn-style">The Designer Collection</button></a>
                                    </div>
                                </div>
                            </div>




                            <!-- ROW TYPE A: 7 LEFT + 3 RIGHT -->
                            <div class="col-lg-7">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <img src="https://mobileimages.lowes.com/productimages/ad71c0c7-4a57-4d8a-bc8f-9c5976f123bf/15269803.jpg"
                                            alt="The Iconic Whites (The Signature)">
                                    </div>
                                    <div class="cont mt-20px d-flex align-items-center justify-content-between">
                                        <a href="https://jainmarble.com/products/The-Iconic-Whites-The-Signature"><button
                                                class="btn-style">The Iconic Whites (The Signature)</button></a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-3">
                                <div class="item mt-60px">
                                    <div class="fit-img o-hidden h-450px border-radius-15px">
                                        <img src="https://jainmarble.com/image/catalog/categories/03 right.webp"
                                            alt="The Iconic Whites (The Signature)">
                                    </div>
                                </div>
                            </div>



                        </div>

                    </div>
                </section>



                <!-- ==================== Start Footer ==================== -->
                <footer class="pt-80px pb-50px footer-bg">
                    <style>
                        .footer-bg {
                            background: url('https://static.vecteezy.com/system/resources/previews/028/217/103/large_2x/high-res-italian-marble-slab-texture-for-tiles-photo.jpg') no-repeat center center/cover;
                            /*background-attachment: fixed;*/
                        }

                        .footer-bg .social-icon-circle a {
                            color: #000;
                        }

                        .footer-bg p,
                        .footer-bg h6,
                        .footer-bg a {
                            color: #000;
                        }
                    </style>

                    <div class="container">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="social-icon-circle">
                                    <a href="https://in.pinterest.com/jainmarblecentre/"> <i
                                            class="fa-brands fa-pinterest"></i> </a>
                                    <a href="https://www.facebook.com/people/Jain-Marble-Centre/100092990035194/"> <i
                                            class="fab fa-facebook-f"></i> </a>
                                    <a href="https://www.instagram.com/jainmarblecentre/"> <i
                                            class="fab fa-instagram"></i> </a>
                                    <a href="https://www.linkedin.com/company/jainmarblecentre/about/"> <i
                                            class="fab fa-linkedin-in"></i> </a>
                                    <a href="https://www.youtube.com/@jainmarblecentre"> <i class="fab fa-youtube"></i>
                                    </a>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="item">
                                    <h6 class="mb-30px">Address </h6>
                                    <p class="fs-14 mb-5px">28/3B/3, opp. Vaishali Metro Station, Maharajpur, Sahibabad
                                        Industrial Area Site 4, Sahibabad, Ghaziabad, Uttar Pradesh 201010</p>
                                    <p class="fs-14 mb-5px">Info@jainmarble.com</p>
                                    <p class="fs-14">9311909087,9311909081</p>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-80px">
                            <div class="col-md-6">
                                <p class="fs-14">© 2026 Design And Developed By <a href="https://aimstorms.com/">
                                        Aimstorms Advertising</a></p>
                            </div>
                            <div class="col-md-6 d-flex justify-content-end">
                                <div class="fs-14">
                                    <a href="https://jainmarble.com/" class="mr-30px">Home</a>
                                    <a href="https://jainmarble.com/about-us" class="mr-30px">About</a>
                                    <a href="https://jainmarble.com/why-choose-us" class="mr-30px">Why Choose Us</a>
                                    <a href="https://jainmarble.com/catalogue" class="mr-30px">Catalogue</a>
                                    <a href="https://jainmarble.com/blog.php" class="mr-30px">Blogs</a>
                                    <a href="https://jainmarble.com/contact-us" class="mr-30px">Contact</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </footer>

                <!-- ==================== End Footer ==================== -->

            </main>


        </div>

    </div>






    <!-- jQuery -->
    <script src="https://jainmarble.com/assets/js/jquery-3.6.0.min.js"></script>
    <script src="https://jainmarble.com/assets/js/jquery-migrate-3.4.0.min.js"></script>

    <!-- plugins -->
    <script src="https://jainmarble.com/assets/js/plugins.js"></script>
    <script src="https://jainmarble.com/assets/js/imagesloaded.pkgd.min.js"></script>

    <script src="https://jainmarble.com/assets/js/gsap.min.js"></script>
    <script src="https://jainmarble.com/assets/js/ScrollSmoother.min.js"></script>
    <script src="https://jainmarble.com/assets/js/ScrollTrigger.min.js"></script>
    <script src="https://jainmarble.com/assets/js/smoother-script.js"></script>

    <!-- custom scripts -->
    <script src="https://jainmarble.com/assets/js/scripts.js"></script>
    <script type="module" src="https://jainmarble.com/assets/js/img-revel/index.js"></script>

    <script src="https://jainmarble.com/assets/js/scrollbased/Flip.min.js"></script>
    <script src="https://jainmarble.com/assets/js/scrollbased/lenis.min.js"></script>
    <script type="module" src="https://jainmarble.com/assets/js/scrollbased/index.js"></script>







    <script>
        // Reveal each section when it enters viewport
        const sections = document.querySelectorAll('.jain-portfolio-item');

        const observer = new IntersectionObserver(entries => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('active');
                }
            });
        }, { threshold: 0.3 });

        sections.forEach(sec => observer.observe(sec));
    </script>



    <script>
        document.querySelectorAll('.catalogue-qury-open').forEach(btn => {
            btn.addEventListener('click', e => {
                e.preventDefault();
                document.querySelector('.catalogue-qury-form-overlay').style.display = 'flex';
            });
        });

        document.querySelector('.catalogue-qury-close').addEventListener('click', () => {
            document.querySelector('.catalogue-qury-form-overlay').style.display = 'none';
        });

        window.addEventListener('click', e => {
            if (e.target.classList.contains('catalogue-qury-form-overlay')) {
                document.querySelector('.catalogue-qury-form-overlay').style.display = 'none';
            }
        });
    </script>



</body>


</html>