<!doctype html>
<html lang="en">

<head>
    <title>Marble Manufacturer & Supplier in Delhi NCR | Jain Marble Centre</title>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Leading marble manufacturer & supplier in Delhi NCR. Explore our wide range of premium marble. Quality & reliability guaranteed by Jain Marble.">
    <meta name="keywords" content="Jain Marble, Jain Marble Centre, Marble Manufacturer in Delhi, marble supplier in delhi">
    <meta name="author" content="@jainmarble">
    <meta name="robots" content="index, follow">
    <meta name="google-site-verification" content="wEgKDvNGOZFSeJU2mJXEj3ud0xq8Rxig9YzbldhRCsM">

    <link rel="canonical" href="https://jainmarble.com/">
    
    <meta property="og:title" content="Marble Manufacturer & Supplier in Delhi NCR | Jain Marble Centre">
    <meta property="og:description" content="Leading marble manufacturer & supplier in Delhi NCR. Explore our wide range of premium marble. Quality & reliability guaranteed by Jain Marble.">
    <meta property="og:url" content="https://jainmarble.com/">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://jainmarble.com/assets/jmc_data/logo/small icon.png">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Marble Manufacturer & Supplier in Delhi NCR | Jain Marble Centre">
    <meta name="twitter:description" content="Leading marble manufacturer & supplier in Delhi NCR. Explore our wide range of premium marble. Quality & reliability guaranteed by Jain Marble.">
    <meta name="twitter:image" content="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <meta name="twitter:site" content="@jainmarble">

    <link rel="shortcut icon" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <link rel="apple-touch-icon" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">
    <link rel="icon" sizes="192x192" href="https://jainmarble.com/assets/jmc_data/logo/small icon.png">

    <link href="https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap" rel="stylesheet">

    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-p1Cm/3S1hYaTK4X6P6V+M3m8Z2aV5/1cXp6qEnhygI3u+cYMCScDZBzLDKCvD+zCMpjk5mx1YjQXKXTcWnM2dg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link rel="stylesheet" href="https://jainmarble.com/assets/css/plugins.css">
    <link rel="stylesheet" href="https://jainmarble.com/assets/css/style.css">
    <link rel="stylesheet" type="text/css" href="https://jainmarble.com/assets/css/base.css">

    <script async src="https://www.googletagmanager.com/gtag/js?id=G-5YVM6BVCFG"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-5YVM6BVCFG');
    </script>
</head>

<body class="marketing-agency freelancer">

    <div class="blur-div"></div>

    <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <div id="smooth-wrapper">
        <div id="smooth-content">
            <main>
                <div class="o-hidden">
                    <div class="bg-img h-600px" data-background="https://jainmarble.com/assets/jmc_data/Catalogue/contact%20main%20banner%20copy.webp" data-speed="0.8" data-lag="0"></div>
                </div>

                <section class="contact-style2 section2">
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-lg-10">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="box-info p-30px border-radius-30px sub-bg mb-30px">
                                            <span class="fs-40 mb-30px"><i class="fa-solid fa-location-dot"></i></span>
                                            <h6 class="fs-18 text-uppercase mb-30px pb-30px line-bottom border-color-transparent-white-light">Address</h6>
                                            <p>28/3B/3, opp. Vaishali Metro Station, Maharajpur, Sahibabad Industrial Area Site 4, Sahibabad, Ghaziabad, Uttar Pradesh 201010</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="box-info p-30px border-radius-30px sub-bg mb-30px">
                                            <span class="fs-40 mb-30px"><i class="fa-solid fa-envelope"></i></span>
                                            <h6 class="fs-18 text-uppercase mb-30px pb-30px line-bottom border-color-transparent-white-light">Mail Support 24/7</h6>
                                            <p><a href="mailto:Info@jainmarble.com">Info@jainmarble.com</a></p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="box-info p-30px border-radius-30px sub-bg mb-30px">
                                            <span class="fs-40 mb-30px"><i class="fa-solid fa-phone"></i></span>
                                            <h6 class="fs-18 text-uppercase mb-30px pb-30px line-bottom border-color-transparent-white-light">Phone</h6>
                                            <p>+91 9311909087</p>
                                            <p>+91 9311909081</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="contact box-dark-gr section2">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-lg-7">
                                <div class="full-width">
                                    <form id="contact-form" class="form2" method="post" action="">
                                        <div class="messages"></div>
                                        <div class="controls row">
                                            <div class="col-lg-6">
                                                <div class="form-group mb-30px">
                                                    <input id="form_name" type="text" name="name" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-30px">
                                                    <input id="form_email" type="email" name="email" placeholder="Email" required>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group mb-30px">
                                                    <input id="form_subject" type="text" name="subject" placeholder="Subject">
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group">
                                                    <textarea id="form_message" name="message" placeholder="Message" rows="4" required></textarea>
                                                </div>
                                                <div class="mt-30px">
                                                    <button type="submit" class="butn butn-full butn-bord radius-30">
                                                        <span class="text">Let's Talk</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-lg-4 offset-lg-1">
                                <div class="info-box full-width md-mb50">
                                    <img src="https://i.pinimg.com/originals/58/ff/89/58ff89a0f9072e966ab97e1bf04477ac.jpg" class="img-fluid">
                                    <div class="social-icon-circle mt-50px">
                                        <a href="https://in.pinterest.com/jainmarblecentre/"><i class="fa-brands fa-pinterest"></i></a>
                                        <a href="https://www.facebook.com/people/Jain-Marble-Centre/100092990035194/"><i class="fab fa-facebook-f"></i></a>
                                        <a href="https://www.instagram.com/jainmarblecentre/"><i class="fab fa-instagram"></i></a>
                                        <a href="https://www.linkedin.com/company/jainmarblecentre/about/"><i class="fab fa-linkedin-in"></i></a>
                                        <a href="https://www.youtube.com/@jainmarblecentre"><i class="fab fa-youtube"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <div class="google-map">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3501.2343138457395!2d77.3419296!3d28.652701999999994!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390cfadc9c93471d%3A0x37cd65c04d57a65f!2sJain%20Marble%20Centre!5e0!3m2!1sen!2sin!4v1762274405138!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </main>
        </div>
    </div>

    <script src="https://jainmarble.com/assets/js/jquery-3.6.0.min.js"></script>
    <script src="https://jainmarble.com/assets/js/jquery-migrate-3.4.0.min.js"></script>
    <script src="https://jainmarble.com/assets/js/plugins.js"></script>
    <script src="https://jainmarble.com/assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="https://jainmarble.com/assets/js/gsap.min.js"></script>
    <script src="https://jainmarble.com/assets/js/ScrollSmoother.min.js"></script>
    <script src="https://jainmarble.com/assets/js/ScrollTrigger.min.js"></script>
    <script src="https://jainmarble.com/assets/js/smoother-script.js"></script>
    <script src="https://jainmarble.com/assets/js/scripts.js"></script>
    <script type="module" src="https://jainmarble.com/assets/js/img-revel/index.js"></script>
    <script src="https://jainmarble.com/assets/js/scrollbased/Flip.min.js"></script>
    <script src="https://jainmarble.com/assets/js/scrollbased/lenis.min.js"></script>
    <script type="module" src="https://jainmarble.com/assets/js/scrollbased/index.js"></script>

    <script>
        const sections = document.querySelectorAll('.jain-portfolio-item');
        const observer = new IntersectionObserver(entries => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('active');
                }
            });
        }, { threshold: 0.3 });
        sections.forEach(sec => observer.observe(sec));

        document.querySelectorAll('.catalogue-qury-open').forEach(btn => {
            btn.addEventListener('click', e => {
                e.preventDefault();
                document.querySelector('.catalogue-qury-form-overlay').style.display = 'flex';
            });
        });

        document.querySelector('.catalogue-qury-close').addEventListener('click', () => {
            document.querySelector('.catalogue-qury-form-overlay').style.display = 'none';
        });

        window.addEventListener('click', e => {
            if (e.target.classList.contains('catalogue-qury-form-overlay')) {
                document.querySelector('.catalogue-qury-form-overlay').style.display = 'none';
            }
        });
    </script>
</body>

</html>
