# 🤖 DizzCall AI - Standalone Test API

A simple, standalone API for testing AI functionality without requiring a full Laravel setup.

## 🚀 Quick Deployment to cPanel

### Step 1: Upload Files
1. Upload the entire `test-api` folder to your cPanel File Manager
2. Place it in `public_html/test-api/` or any subdirectory you prefer

### Step 2: Set Permissions
```bash
chmod 755 test-api/
chmod 644 test-api/index.php
chmod 644 test-api/dashboard.html
chmod 644 test-api/config.php
chmod 644 test-api/.htaccess
```

### Step 3: Test the API
Visit: `https://yourdomain.com/test-api/dashboard`

## 📡 API Endpoints

### Base URL
```
https://yourdomain.com/test-api/
```

### Available Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/connection` | Test AI system connection |
| POST | `/simulate-call` | Simulate phone call conversation |
| POST | `/test-responses` | Test multiple AI responses |
| GET | `/performance` | Get system performance metrics |
| GET | `/scenarios` | Test predefined scenarios |
| GET | `/dashboard` | Show test dashboard |

## 🔧 Configuration

Edit `config.php` to customize:
- Gemini API key
- Company information
- Response contexts
- Timeout settings

## 📞 Usage Examples

### Test Connection
```bash
curl https://yourdomain.com/test-api/connection
```

### Simulate Phone Call
```bash
curl -X POST https://yourdomain.com/test-api/simulate-call \
  -H "Content-Type: application/json" \
  -d '{
    "caller_phone": "+1234567890",
    "message": "Hello, I need help with your services",
    "conversation_type": "general"
  }'
```

### Test Multiple Messages
```bash
curl -X POST https://yourdomain.com/test-api/test-responses \
  -H "Content-Type: application/json" \
  -d '{
    "test_messages": [
      "Hello, I need help",
      "What are your prices?",
      "Can I schedule a meeting?"
    ]
  }'
```

## 🌐 Web Dashboard

Access the test dashboard at: `https://yourdomain.com/test-api/dashboard`

Features:
- Real-time AI testing
- Phone call simulation
- Performance metrics
- Results logging
- Quick test scenarios

## 📊 Response Format

All API responses follow this format:

```json
{
  "success": true,
  "message": "Operation completed",
  "data": {
    // Response data here
  },
  "timestamp": "2024-01-15T10:30:00.000Z"
}
```

## 🚨 Error Handling

Error responses:
```json
{
  "success": false,
  "message": "Error description",
  "error": "Detailed error message",
  "timestamp": "2024-01-15T10:30:00.000Z"
}
```

## 📝 Logging

Test calls are logged to `logs/test_calls.log` for analysis and debugging.

## 🔒 Security

- CORS enabled for cross-origin requests
- Input validation on all endpoints
- Rate limiting through PHP timeout settings
- No authentication required (testing only)

## 🆘 Troubleshooting

### Common Issues

1. **500 Internal Server Error**
   - Check file permissions
   - Verify PHP version (7.4+ required)
   - Check error logs

2. **AI Not Responding**
   - Verify Gemini API key in config.php
   - Check internet connection
   - Verify API quota

3. **CORS Issues**
   - Check .htaccess file
   - Verify server supports mod_rewrite

## 📞 Support

For technical support:
- Email: info@dizaartsystems.com
- Phone: +16084969211

---

**🎉 Your AI test API is ready for client testing!**
