<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('call_logs', function (Blueprint $table) {
            $table->id();
            $table->string('from_number');
            $table->string('to_number');
            $table->enum('direction', ['incoming', 'outbound']);
            $table->enum('status', ['initiated', 'started', 'completed', 'failed', 'busy', 'no-answer']);
            $table->timestamp('started_at')->nullable();
            $table->timestamp('ended_at')->nullable();
            $table->integer('duration')->nullable(); // in seconds
            $table->string('call_sid')->nullable(); // Twilio call SID
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('contact_id')->nullable()->constrained()->onDelete('set null');
            $table->text('transcript')->nullable();
            $table->string('recording_url')->nullable();
            $table->timestamps();
            
            $table->index(['from_number', 'to_number']);
            $table->index(['status', 'started_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('call_logs');
    }
};
