<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Twilio Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for Twilio phone integration
    |
    */

    'account_sid' => env('TWILIO_ACCOUNT_SID'),
    'auth_token' => env('TWILIO_AUTH_TOKEN'),
    'phone_number' => env('TWILIO_PHONE_NUMBER'),
    'webhook_url' => env('TWILIO_WEBHOOK_URL', env('APP_URL') . '/api/twilio/webhook'),
    
    /*
    |--------------------------------------------------------------------------
    | Voice Settings
    |--------------------------------------------------------------------------
    */
    
    'voice' => [
        'language' => 'en-US',
        'voice' => 'Polly.Joanna', // Professional female voice
        'gender' => 'female',
        'speed' => 2.2,  // 120% faster - ultra-fast like CRM
        'pitch' => 1.05, // Slightly higher for clarity
        'volume' => 1.15, // Louder for better presence
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Call Settings
    |--------------------------------------------------------------------------
    */
    
    'call' => [
        'timeout' => 30, // seconds
        'record' => true,
        'transcribe' => true,
        'max_duration' => 300, // 5 minutes
    ],
    
    /*
    |--------------------------------------------------------------------------
    | AI Integration
    |--------------------------------------------------------------------------
    */
    
    'ai' => [
        'enabled' => true,
        'model' => 'gemma:2b',
        'response_timeout' => 1, // seconds - ultra fast for phone calls
        'max_tokens' => 20,      // very short responses for phone
        'temperature' => 0.1,    // very focused responses
    ],
];
