<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'user_id',
        'company_name',
        'contact_number',
        'alternate_number',
        'address',
        'business_type',
        'website',
        'gstin',
        'status',
        'license_id',
        'is_admin',
        'wallet_balance',
        'avatar',
        'theme',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_admin' => 'boolean',
    ];


    /**
     * Get the license associated with the user.
     */
    public function license()
    {
        return $this->hasOne(License::class);
    }

    public function walletTransactions()
    {
        return $this->hasMany(WalletTransaction::class);
    }
}