<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Lookups;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Lookups\V2\BucketList;
use Twilio\Rest\Lookups\V2\LookupOverrideList;
use Twilio\Rest\Lookups\V2\PhoneNumberList;
use Twilio\Rest\Lookups\V2\QueryList;
use Twilio\Rest\Lookups\V2\RateLimitList;
use Twilio\Version;

/**
 * @property BucketList $bucket
 * @property LookupOverrideList $lookupOverrides
 * @property PhoneNumberList $phoneNumbers
 * @property QueryList $query
 * @property RateLimitList $rateLimits
 * @method \Twilio\Rest\Lookups\V2\PhoneNumberContext phoneNumbers(string $phoneNumber)
 * @method \Twilio\Rest\Lookups\V2\BucketContext bucket(string $field, string $bucket)
 * @method \Twilio\Rest\Lookups\V2\LookupOverrideContext lookupOverrides(string $field, string $phoneNumber)
 */
class V2 extends Version
{
    protected $_bucket;
    protected $_lookupOverrides;
    protected $_phoneNumbers;
    protected $_query;
    protected $_rateLimits;

    /**
     * Construct the V2 version of Lookups
     *
     * @param Domain $domain Domain that contains the version
     */
    public function __construct(Domain $domain)
    {
        parent::__construct($domain);
        $this->version = 'v2';
    }

    protected function getBucket(): BucketList
    {
        if (!$this->_bucket) {
            $this->_bucket = new BucketList($this);
        }
        return $this->_bucket;
    }

    protected function getLookupOverrides(): LookupOverrideList
    {
        if (!$this->_lookupOverrides) {
            $this->_lookupOverrides = new LookupOverrideList($this);
        }
        return $this->_lookupOverrides;
    }

    protected function getPhoneNumbers(): PhoneNumberList
    {
        if (!$this->_phoneNumbers) {
            $this->_phoneNumbers = new PhoneNumberList($this);
        }
        return $this->_phoneNumbers;
    }

    protected function getQuery(): QueryList
    {
        if (!$this->_query) {
            $this->_query = new QueryList($this);
        }
        return $this->_query;
    }

    protected function getRateLimits(): RateLimitList
    {
        if (!$this->_rateLimits) {
            $this->_rateLimits = new RateLimitList($this);
        }
        return $this->_rateLimits;
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     * @return \Twilio\ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get(string $name)
    {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext
    {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Lookups.V2]';
    }
}
