<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'User Dashboard') - DizzCall AI</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/style.css') }}">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
    <style>
        :root {
            --primary: #3a0ca3;
            --primary-light: #4361ee;
            --secondary: #7209b7;
            --secondary-light: #4cc9f0;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #212529;
            --gray: #6c757d;
            --light-gray: #e9ecef;
            --success: #4ade80;
            --warning: #facc15;
            --danger: #ef4444;
            --info: #4895ef;
            --sidebar-width: 280px;
            --sidebar-collapsed-width: 80px;
            --transition-speed: 0.3s;
            --card-border-radius: 16px;
            --element-border-radius: 12px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f8fafc;
            color: var(--dark);
            overflow-x: hidden;
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
            width: 100vw;
            margin: 0;
            padding: 0;
        }

        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            background: linear-gradient(180deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            transition: width var(--transition-speed) ease;
            box-shadow: 2px 0 15px rgba(0, 0, 0, 0.1);
            flex-shrink: 0;
        }

        .sidebar.collapsed {
            width: var(--sidebar-collapsed-width);
        }

        .logo-container {
            padding: 20px 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .logo-text {
            font-size: 20px;
            font-weight: 700;
            white-space: nowrap;
            overflow: hidden;
            transition: opacity var(--transition-speed);
        }

        .sidebar.collapsed .logo-text {
            opacity: 0;
            width: 0;
        }

        .toggle-btn {
            background: transparent;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 20px;
            transition: transform var(--transition-speed);
            padding: 5px;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .toggle-btn:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .sidebar.collapsed .toggle-btn {
            transform: rotate(180deg);
        }

        .nav-menu {
            list-style: none;
            padding: 20px 0;
            margin: 0;
        }

        .nav-item {
            margin-bottom: 5px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s ease;
            border-left: 3px solid transparent;
            white-space: nowrap;
        }

        .nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
            padding-left: 25px;
        }

        .nav-link.active {
            background-color: rgba(255, 255, 255, 0.15);
            color: white;
            border-left: 3px solid white;
        }

        .nav-icon {
            margin-right: 15px;
            width: 20px;
            text-align: center;
            font-size: 18px;
            transition: margin var(--transition-speed);
        }

        .sidebar.collapsed .nav-icon {
            margin-right: 0;
        }

        .nav-text {
            flex: 1;
            transition: opacity var(--transition-speed);
            opacity: 1;
        }

        .sidebar.collapsed .nav-text {
            opacity: 0;
            width: 0;
            height: 0;
            overflow: hidden;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            padding: 20px 30px;
            margin-left: var(--sidebar-width);
            transition: margin-left var(--transition-speed);
            min-height: 100vh;
            background-color: #f8fafc;
            width: calc(100vw - var(--sidebar-width));
        }

        .main-content.expanded {
            margin-left: var(--sidebar-collapsed-width);
            width: calc(100vw - var(--sidebar-collapsed-width));
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            background-color: white;
            padding: 18px 30px;
            border-radius: var(--card-border-radius);
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
        }

        .page-title h1 {
            margin: 0;
            font-size: 26px;
            font-weight: 700;
            color: var(--dark);
            background: linear-gradient(90deg, var(--primary), var(--accent));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .user-actions {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .search-bar {
            position: relative;
            display: flex;
            align-items: center;
        }

        .search-bar i {
            position: absolute;
            left: 15px;
            color: var(--gray);
            z-index: 1;
        }

        .search-bar input {
            padding: 12px 15px 12px 45px;
            border: 1px solid var(--light-gray);
            border-radius: 30px;
            width: 220px;
            transition: all 0.3s ease;
            background-color: #f8f9fa;
            font-size: 14px;
        }

        .search-bar input:focus {
            width: 280px;
            border-color: var(--primary-light);
            outline: none;
            box-shadow: 0 0 0 4px rgba(67, 97, 238, 0.1);
            background-color: white;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
            padding: 8px 15px;
            border-radius: 30px;
            transition: all 0.3s ease;
        }

        .user-profile:hover {
            background-color: #f0f2f5;
        }

        .user-profile img {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary-light);
        }

        .user-info h4 {
            margin: 0;
            font-size: 15px;
            font-weight: 600;
        }

        .user-info p {
            margin: 0;
            font-size: 13px;
            color: var(--gray);
        }

        .btn-logout {
            background-color: transparent;
            border: 1px solid var(--danger);
            color: var(--danger);
            padding: 10px 18px;
            border-radius: 30px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-logout:hover {
            background-color: var(--danger);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(249, 65, 68, 0.3);
        }

        /* Dashboard Content */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background-color: white;
            border-radius: var(--card-border-radius);
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .stat-card:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary), var(--primary-light));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .stat-card:hover:before {
            opacity: 1;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        .stat-icon {
            font-size: 26px;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }

        .users-icon {
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .calls-icon {
            background-color: rgba(76, 201, 240, 0.1);
            color: var(--info);
        }

        .revenue-icon {
            background-color: rgba(247, 37, 133, 0.1);
            color: var(--accent);
        }

        .active-icon {
            background-color: rgba(74, 222, 128, 0.1);
            color: var(--success);
        }

        .stat-title {
            font-size: 15px;
            color: var(--gray);
            margin-bottom: 10px;
            font-weight: 500;
        }

        .stat-value {
            font-size: 28px;
            font-weight: 800;
            color: var(--dark);
        }

        .stat-trend {
            font-size: 13px;
            margin-top: 5px;
        }

        .trend-up {
            color: var(--success);
        }

        .trend-down {
            color: var(--danger);
        }

        /* Tables */
        .table-container {
            background-color: white;
            border-radius: var(--card-border-radius);
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }

        .table-title {
            font-size: 20px;
            font-weight: 700;
            margin: 0;
            color: var(--dark);
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            border: none;
            padding: 10px 20px;
            border-radius: 30px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
            color: white;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(67, 97, 238, 0.4);
            background: linear-gradient(135deg, var(--primary-light) 0%, var(--primary) 100%);
            color: white;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th {
            text-align: left;
            padding: 15px;
            background-color: var(--light);
            color: var(--gray);
            font-weight: 600;
            font-size: 14px;
            border-bottom: 2px solid var(--light-gray);
        }

        td {
            padding: 15px;
            border-bottom: 1px solid var(--light-gray);
            font-size: 14px;
        }

        tr:last-child td {
            border-bottom: none;
        }

        tr:hover td {
            background-color: rgba(67, 97, 238, 0.05);
        }

        .status {
            display: inline-block;
            padding: 7px 14px;
            border-radius: 30px;
            font-size: 12px;
            font-weight: 600;
        }

        .status.active {
            background-color: rgba(76, 201, 240, 0.2);
            color: var(--info);
        }

        .status.pending {
            background-color: rgba(248, 150, 30, 0.2);
            color: var(--warning);
        }

        .status.completed {
            background-color: rgba(67, 97, 238, 0.2);
            color: var(--primary);
        }

        .status.inactive {
            background-color: rgba(108, 117, 125, 0.2);
            color: var(--gray);
        }

        .action-btn {
            background-color: transparent;
            border: 1px solid var(--light-gray);
            color: var(--gray);
            width: 35px;
            height: 35px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-right: 8px;
        }

        .action-btn:hover {
            background-color: var(--light);
            color: var(--primary);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .action-btn.danger:hover {
            color: var(--danger);
            border-color: var(--danger);
        }

        /* Charts Section */
        .charts-row {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }

        .chart-container {
            background-color: white;
            border-radius: var(--card-border-radius);
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .chart-placeholder {
            background: linear-gradient(45deg, #f8fafc, #e2e8f0);
            border-radius: 12px;
            height: 300px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--gray);
            font-weight: 600;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .dashboard-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
                left: 0;
                top: 0;
                z-index: 100;
            }
            
            .sidebar.collapsed {
                width: 100%;
            }
            
            .main-content {
                margin-left: 0;
                padding: 15px;
                width: 100%;
            }
            
            .main-content.expanded {
                margin-left: 0;
                width: 100%;
            }
            
            .header {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }
            
            .user-actions {
                width: 100%;
                justify-content: space-between;
            }
            
            .search-bar input {
                width: 150px;
            }
            
            .search-bar input:focus {
                width: 200px;
            }
            
            .mobile-toggle {
                display: block !important;
            }
            
            .charts-row {
                grid-template-columns: 1fr;
            }
            
            .nav-menu {
                display: flex;
                flex-wrap: wrap;
                padding: 10px 0;
            }
            
            .nav-item {
                flex: 1;
                min-width: 120px;
                margin-bottom: 0;
            }
            
            .nav-link {
                flex-direction: column;
                padding: 10px 5px;
                text-align: center;
                border-left: none;
                border-bottom: 3px solid transparent;
            }
            
            .nav-link:hover {
                padding-left: 5px;
                border-left: none;
                border-bottom: 3px solid white;
            }
            
            .nav-link.active {
                border-left: none;
                border-bottom: 3px solid white;
            }
            
            .nav-icon {
                margin-right: 0;
                margin-bottom: 5px;
            }
            
            .nav-text {
                font-size: 12px;
                opacity: 1;
                width: auto;
                height: auto;
                overflow: visible;
            }
            
            .logo-container {
                padding: 15px;
            }
            
            .logo-text {
                opacity: 1;
                width: auto;
            }
        }

        .mobile-toggle {
            display: none;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            border: none;
            border-radius: var(--element-border-radius);
            padding: 10px 15px;
            margin-bottom: 20px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .mobile-toggle:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }

        /* Footer */
        .footer {
            text-align: center;
            padding: 20px;
            color: var(--gray);
            font-size: 14px;
            margin-top: 30px;
        }
    </style>
</head>

<body class="{{ Auth::user()->theme ?? 'light' }}">
    <!-- Dashboard Container -->
    <div class="dashboard-container">
        <!-- Sidebar -->
        @include('FrontUser.layouts.sidebar')

        <!-- Main Content -->
        <main class="main-content">
            <!-- Header -->
            @include('FrontUser.layouts.header')
            
            <!-- Dashboard Content -->
            @yield('content')
            
            <!-- Footer -->
            @include('FrontUser.layouts.footer')
        </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle sidebar
            const toggleBtn = document.querySelector('.toggle-btn');
            const sidebar = document.querySelector('.sidebar');
            const mainContent = document.querySelector('.main-content');
            const mobileToggle = document.querySelector('.mobile-toggle');
            
            if (toggleBtn) {
                toggleBtn.addEventListener('click', function() {
                    sidebar.classList.toggle('collapsed');
                    mainContent.classList.toggle('expanded');
                });
            }
            
            if (mobileToggle) {
                mobileToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('mobile-show');
                });
            }
            
            // Initialize charts or other components
            console.log('User dashboard initialized');
        });
    </script>
    
    @yield('scripts')
</body>
</html>