# 🚀 DizzCall AI - cPanel Deployment Guide

## 📋 **PRE-DEPLOYMENT CHECKLIST**

### **1. Database Setup in cPanel**
1. **Login to cPanel** → `https://princedevops.live:2083`
2. **Go to MySQL Databases**
3. **Create Database**: `princedevops_dizzcall_ai`
4. **Create User**: `princedevops_8076`
5. **Set Password**: `1qaz!QAZ@123`
6. **Add User to Database** with **ALL PRIVILEGES**

### **2. File Manager Setup**
1. **Go to File Manager** in cPanel
2. **Navigate to**: `/public_html/`
3. **Create folder**: `dizzcall-ai`
4. **Set permissions**: `755` for the folder

---

## 📦 **STEP 1: PREPARE FILES FOR UPLOAD**

### **Run the deployment script:**
```bash
# In your local project directory
chmod +x deploy-to-cpanel.sh
./deploy-to-cpanel.sh
```

This will create:
- `dizzcall-ai-production.zip` - Ready to upload
- `.env.production` - Environment file
- `cpanel-setup.php` - Setup verification

---

## 📤 **STEP 2: UPLOAD TO CPANEL**

### **Method 1: File Manager Upload**
1. **Login to cPanel** → **File Manager**
2. **Navigate to**: `/public_html/dizzcall-ai/`
3. **Upload**: `dizzcall-ai-production.zip`
4. **Extract** the zip file
5. **Delete** the zip file after extraction

### **Method 2: FTP Upload**
1. **Use FTP client** (FileZilla, WinSCP)
2. **Host**: `princedevops.live`
3. **Username**: Your cPanel username
4. **Password**: Your cPanel password
5. **Upload to**: `/public_html/dizzcall-ai/`

---

## ⚙️ **STEP 3: CONFIGURE APPLICATION**

### **3.1 Create .env File**
1. **In File Manager**, go to `/public_html/dizzcall-ai/`
2. **Create new file**: `.env`
3. **Copy contents** from `.env.production`:

```env
APP_NAME="DizzCall AI"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://princedevops.live/dizzcall-ai/public

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

# Database Configuration
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=princedevops_dizzcall_ai
DB_USERNAME=princedevops_8076
DB_PASSWORD=1qaz!QAZ@123

# Cache Configuration
BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

# Mail Configuration
MAIL_MAILER=smtp
MAIL_HOST=mail.princedevops.live
MAIL_PORT=587
MAIL_USERNAME=noreply@princedevops.live
MAIL_PASSWORD=your_email_password_here
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@princedevops.live
MAIL_FROM_NAME="${APP_NAME}"

# Twilio Configuration
TWILIO_ACCOUNT_SID=ACba8ab371660f38e4427e334cc0c4a7fc
TWILIO_AUTH_TOKEN=b606503f25ce1f2115dc8aec158ce90b
TWILIO_PHONE_NUMBER=+16084969211
TWILIO_WEBHOOK_URL=https://princedevops.live/dizzcall-ai/public/api/twilio/webhook

# Gemini AI Configuration
GEMINI_API_KEY=AIzaSyA90MNxC9K8aOh9u9sRHpHba55pfDK2QoM

# AI Configuration
AI_MAX_TOKENS=20
AI_TEMPERATURE=0.1
AI_TIMEOUT=1
```

### **3.2 Set File Permissions**
1. **Right-click** on `storage/` folder → **Permissions** → `755`
2. **Right-click** on `bootstrap/cache/` folder → **Permissions** → `755`
3. **Right-click** on `.env` file → **Permissions** → `644`

---

## 🔧 **STEP 4: RUN LARAVEL COMMANDS**

### **4.1 Access Terminal/SSH**
1. **Go to cPanel** → **Terminal** (or **SSH Access**)
2. **Navigate to project**:
   ```bash
   cd /home/princedevops/public_html/dizzcall-ai
   ```

### **4.2 Run Laravel Commands**
```bash
# Generate application key
php artisan key:generate

# Run database migrations
php artisan migrate

# Clear and cache configurations
php artisan config:clear
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Create storage symlink
php artisan storage:link
```

---

## 🌐 **STEP 5: CONFIGURE .HTACCESS**

### **5.1 Main .htaccess (in /public_html/dizzcall-ai/)**
Create `.htaccess` file in the root directory:

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    
    # Redirect to public directory
    RewriteCond %{REQUEST_URI} !^/dizzcall-ai/public/
    RewriteRule ^(.*)$ /dizzcall-ai/public/$1 [L,R=301]
</IfModule>
```

### **5.2 Public .htaccess (in /public_html/dizzcall-ai/public/)**
Ensure this file exists:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

---

## 🧪 **STEP 6: TEST DEPLOYMENT**

### **6.1 Test URLs**
1. **Main App**: `https://princedevops.live/dizzcall-ai/public/`
2. **Setup Check**: `https://princedevops.live/dizzcall-ai/public/cpanel-setup.php`
3. **AI Dashboard**: `https://princedevops.live/dizzcall-ai/public/ai-test-dashboard`

### **6.2 Test Phone System**
1. **Call**: `+16084969211`
2. **Test AI responses**
3. **Check webhook logs**

---

## 🔗 **STEP 7: UPDATE TWILIO WEBHOOKS**

### **7.1 Login to Twilio Console**
1. **Go to**: `https://console.twilio.com/`
2. **Navigate to**: Phone Numbers → Manage → Active Numbers
3. **Click on**: `+16084969211`

### **7.2 Update Webhook URLs**
- **Voice URL**: `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/incoming`
- **Status Callback URL**: `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/outbound`

---

## ✅ **VERIFICATION CHECKLIST**

### **Before Going Live:**
- [ ] Database created and user assigned
- [ ] Files uploaded to `/public_html/dizzcall-ai/`
- [ ] `.env` file created with correct credentials
- [ ] File permissions set (storage: 755, .env: 644)
- [ ] Laravel commands run successfully
- [ ] `.htaccess` files configured
- [ ] Test URLs working
- [ ] Twilio webhooks updated
- [ ] Phone system tested

### **Live URLs:**
- **Main App**: `https://princedevops.live/dizzcall-ai/public/`
- **AI Chat**: `https://princedevops.live/dizzcall-ai/public/ai-test-dashboard`
- **Phone**: `+16084969211`

---

## 🚨 **TROUBLESHOOTING**

### **Common Issues:**

**1. 500 Internal Server Error**
- Check file permissions
- Verify `.env` file exists
- Check Laravel logs in `storage/logs/`

**2. Database Connection Error**
- Verify database credentials
- Check if database exists
- Ensure user has proper privileges

**3. Twilio Webhook Not Working**
- Verify HTTPS is enabled
- Check webhook URLs are correct
- Test with ngrok first if needed

**4. File Not Found Errors**
- Check `.htaccess` configuration
- Verify file paths are correct
- Ensure Laravel routes are cached

---

## 🎯 **SUCCESS!**

Once all steps are completed, your DizzCall AI will be live at:
**`https://princedevops.live/dizzcall-ai/public/`**

**Phone System**: Call `+16084969211` to test! 📞✨