# 🚀 DizzCall AI - cPanel Deployment Guide

## 📋 Prerequisites

### 1. cPanel Access
- Login to your cPanel account
- Ensure you have access to File Manager
- Check PHP version (requires PHP 8.1+)

### 2. Domain Setup
- Domain: `princedevops.live`
- Subdirectory: `dizzcall-ai` (optional)
- SSL Certificate enabled

## 🔧 Step 1: Prepare Your Local Files

### 1.1 Create Production Environment File
```bash
# Copy .env file for production
cp .env .env.production
```

### 1.2 Update .env.production
```env
APP_NAME="DizzCall AI"
APP_ENV=production
APP_KEY=base64:YOUR_APP_KEY_HERE
APP_DEBUG=false
APP_URL=https://princedevops.live/dizzcall-ai/public

# Database Configuration
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=princedevops_dizzcall
DB_USERNAME=princedevops_user
DB_PASSWORD=your_secure_password

# Twilio Configuration
TWILIO_ACCOUNT_SID=ACba8ab371660f38e4427e334cc0c4a7fc
TWILIO_AUTH_TOKEN=b606503f25ce1f2115dc8aec158ce90b
TWILIO_PHONE_NUMBER=+16084969211
TWILIO_WEBHOOK_URL=https://princedevops.live/dizzcall-ai/public/api/twilio/webhook

# Gemini AI
GEMINI_API_KEY=AIzaSyA90MNxC9K8aOh9u9sRHpHba55pfDK2QoM

# Mail Configuration
MAIL_MAILER=smtp
MAIL_HOST=mail.princedevops.live
MAIL_PORT=587
MAIL_USERNAME=noreply@princedevops.live
MAIL_PASSWORD=your_email_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@princedevops.live
MAIL_FROM_NAME="${APP_NAME}"
```

## 📁 Step 2: Upload Files to cPanel

### 2.1 Access File Manager
1. Login to cPanel
2. Go to **File Manager**
3. Navigate to `public_html/`
4. Create folder: `dizzcall-ai`

### 2.2 Upload Laravel Files
Upload these folders/files to `public_html/dizzcall-ai/`:

**Required Folders:**
- `app/`
- `bootstrap/`
- `config/`
- `database/`
- `resources/`
- `routes/`
- `storage/`
- `vendor/` (or install via Composer)

**Required Files:**
- `artisan`
- `composer.json`
- `composer.lock`
- `.env.production` (rename to `.env`)

**DO NOT UPLOAD:**
- `node_modules/`
- `.git/`
- `tests/`
- `storage/logs/*.log`

### 2.3 Move Public Files
1. Create folder: `public_html/dizzcall-ai/public/`
2. Move these files from `public/` to `public_html/dizzcall-ai/public/`:
   - `index.php`
   - `css/`
   - `js/`
   - `build/`
   - `favicon.ico`
   - `robots.txt`

## 🗄️ Step 3: Database Setup

### 3.1 Create Database
1. Go to **MySQL Databases** in cPanel
2. Create database: `princedevops_dizzcall`
3. Create user: `princedevops_user`
4. Assign user to database with ALL PRIVILEGES
5. Note down the credentials

### 3.2 Import Database Structure
```bash
# Via cPanel Terminal or SSH
cd /home/princedevops/public_html/dizzcall-ai
php artisan migrate
```

## ⚙️ Step 4: Configure Laravel

### 4.1 Set Permissions
```bash
# Set proper permissions
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
chmod 644 .env
```

### 4.2 Generate Application Key
```bash
# Generate new app key
php artisan key:generate
```

### 4.3 Clear Caches
```bash
# Clear all caches
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan cache:clear
```

## 🌐 Step 5: Configure Web Server

### 5.1 Update .htaccess
Create/update `public_html/dizzcall-ai/public/.htaccess`:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

### 5.2 Update index.php
Update `public_html/dizzcall-ai/public/index.php`:

```php
<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Adjust this path to your Laravel installation
require __DIR__.'/../../vendor/autoload.php';

$app = require_once __DIR__.'/../../bootstrap/app.php';

$kernel = $app->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response);
```

## 📞 Step 6: Update Twilio Webhooks

### 6.1 Update Twilio Console
1. Go to [Twilio Console](https://console.twilio.com/)
2. Navigate to **Phone Numbers** > **Manage** > **Active numbers**
3. Click on your number `+16084969211`
4. Update webhook URLs:
   - **Voice**: `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/incoming`
   - **Status**: `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/outbound`

## 🧪 Step 7: Test Deployment

### 7.1 Test Website
Visit: `https://princedevops.live/dizzcall-ai/public/`

### 7.2 Test AI Dashboard
Visit: `https://princedevops.live/dizzcall-ai/public/ai-test-dashboard`

### 7.3 Test Phone System
Call: `+16084969211`

## 🔧 Step 8: Production Optimizations

### 8.1 Enable Production Mode
```bash
# Set production environment
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### 8.2 Set Up Cron Jobs
In cPanel **Cron Jobs**, add:
```bash
# Run every minute
* * * * * cd /home/princedevops/public_html/dizzcall-ai && php artisan schedule:run >> /dev/null 2>&1
```

### 8.3 Enable SSL
1. Go to **SSL/TLS** in cPanel
2. Enable **Force HTTPS Redirect**
3. Install SSL certificate (Let's Encrypt recommended)

## 🚨 Troubleshooting

### Common Issues:

**1. 500 Internal Server Error**
- Check file permissions
- Verify .env file exists
- Check Laravel logs: `storage/logs/laravel.log`

**2. Database Connection Error**
- Verify database credentials in .env
- Check if database exists
- Ensure user has proper permissions

**3. Twilio Webhook Not Working**
- Verify webhook URLs are correct
- Check if HTTPS is enabled
- Test webhook endpoints manually

**4. File Not Found Errors**
- Verify .htaccess is in public folder
- Check if mod_rewrite is enabled
- Ensure index.php path is correct

## 📞 Support

If you encounter issues:
1. Check Laravel logs: `storage/logs/laravel.log`
2. Verify all configurations
3. Test each component individually

## ✅ Final Checklist

- [ ] Files uploaded to cPanel
- [ ] Database created and migrated
- [ ] .env file configured
- [ ] Permissions set correctly
- [ ] Webhooks updated in Twilio
- [ ] SSL certificate enabled
- [ ] Website accessible
- [ ] AI dashboard working
- [ ] Phone system functional

---

**🎉 Your DizzCall AI system is now live at: `https://princedevops.live/dizzcall-ai/public/`**
