# 🚀 QUICK DEPLOYMENT STEPS - DizzCall AI

## ✅ **YOUR DATABASE CREDENTIALS (UPDATED)**
```env
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=princedevops_dizzcall_ai
DB_USERNAME=princedevops_8076
DB_PASSWORD=1qaz!QAZ@123
```

---

## 📋 **STEP-BY-STEP DEPLOYMENT**

### **STEP 1: Prepare Files (Run This First)**
```bash
# In your project directory
chmod +x deploy-to-cpanel.sh
./deploy-to-cpanel.sh
```
This creates: `dizzcall-ai-deployment.zip`

### **STEP 2: cPanel Database Setup**
1. **Login to cPanel** → `https://princedevops.live:2083`
2. **MySQL Databases** → Create Database: `princedevops_dizzcall_ai`
3. **Create User**: `princedevops_8076` with password: `1qaz!QAZ@123`
4. **Add User to Database** with **ALL PRIVILEGES**

### **STEP 3: Upload Files**
1. **File Manager** → Navigate to `/public_html/`
2. **Create folder**: `dizzcall-ai`
3. **Upload**: `dizzcall-ai-deployment.zip`
4. **Extract** the zip file
5. **Delete** the zip file

### **STEP 4: Set Permissions**
1. **Right-click** `storage/` → **Permissions** → `755`
2. **Right-click** `bootstrap/cache/` → **Permissions** → `755`
3. **Right-click** `.env` → **Permissions** → `644`

### **STEP 5: Run Laravel Commands**
1. **cPanel Terminal** (or SSH)
2. **Navigate**: `cd /home/princedevops/public_html/dizzcall-ai`
3. **Run commands**:
```bash
php artisan key:generate
php artisan migrate
php artisan config:cache
php artisan route:cache
```

### **STEP 6: Test Deployment**
Visit: `https://princedevops.live/dizzcall-ai/public/cpanel-deployment-test.php`

---

## 🌐 **YOUR LIVE URLs**

- **Main App**: `https://princedevops.live/dizzcall-ai/public/`
- **AI Dashboard**: `https://princedevops.live/dizzcall-ai/public/ai-test-dashboard`
- **Deployment Test**: `https://princedevops.live/dizzcall-ai/public/cpanel-deployment-test.php`

---

## 📞 **TWILIO WEBHOOKS TO UPDATE**

1. **Login to Twilio Console**
2. **Phone Numbers** → `+16084969211`
3. **Update Webhooks**:
   - **Voice URL**: `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/incoming`
   - **Status Callback**: `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/outbound`

---

## ✅ **VERIFICATION CHECKLIST**

- [ ] Database created and user assigned
- [ ] Files uploaded to `/public_html/dizzcall-ai/`
- [ ] File permissions set correctly
- [ ] Laravel commands run successfully
- [ ] Test page shows all green checkmarks
- [ ] Twilio webhooks updated
- [ ] Phone system tested

---

## 🎯 **READY TO GO LIVE!**

Once all steps are complete, your DizzCall AI will be live at:
**`https://princedevops.live/dizzcall-ai/public/`**

**Test by calling: `+16084969211`** 📞✨











