# 🚀 DizzCall AI Test API - cPanel Deployment Guide

## 📋 Overview
This guide will help you deploy a standalone AI testing API to your cPanel server. This is completely separate from your main Laravel application and perfect for client testing.

## 🎯 What You'll Get
- **Standalone API** - No Laravel required
- **Web Dashboard** - Easy testing interface
- **Real-time AI Testing** - Test AI responses instantly
- **Client Ready** - Perfect for client demonstrations

---

## 📦 Step 1: Prepare Deployment Package

### Option A: Use Deployment Script (Recommended)
1. **Run the deployment script:**
   ```bash
   # On Windows
   cd test-api
   deploy.bat
   
   # On Linux/Mac
   cd test-api
   chmod +x deploy.sh
   ./deploy.sh
   ```

2. **This creates:** `dizzcall-ai-test-api.zip`

### Option B: Manual Preparation
1. Create folder: `dizzcall-ai-test-api`
2. Copy these files:
   - `index.php`
   - `dashboard.html`
   - `config.php`
   - `.htaccess`
   - `README.md`
3. Create subfolder: `logs`
4. Create empty file: `logs/test_calls.log`
5. Zip the entire folder

---

## 📤 Step 2: Upload to cPanel

### 2.1 Access cPanel File Manager
1. **Login to cPanel** → `https://princedevops.live:2083`
2. **Go to File Manager**
3. **Navigate to** `/public_html/`

### 2.2 Upload and Extract
1. **Upload** `dizzcall-ai-test-api.zip` to `/public_html/`
2. **Right-click** on the zip file → **Extract**
3. **Delete** the zip file after extraction
4. **Verify** you have this structure:
   ```
   public_html/
   └── dizzcall-ai-test-api/
       ├── index.php
       ├── dashboard.html
       ├── config.php
       ├── .htaccess
       ├── README.md
       └── logs/
           └── test_calls.log
   ```

---

## ⚙️ Step 3: Configure the API

### 3.1 Edit Configuration (Optional)
1. **Open** `config.php` in File Manager
2. **Update** if needed:
   ```php
   'gemini_api_key' => 'AIzaSyA90MNxC9K8aOh9u9sRHpHba55pfDK2QoM',
   'company_name' => 'Dizaart Systems',
   'ai_assistant_name' => 'Alex',
   'phone_number' => '+16084969211',
   ```

### 3.2 Set File Permissions
1. **Right-click** on `dizzcall-ai-test-api` folder → **Permissions** → `755`
2. **Right-click** on `logs` folder → **Permissions** → `755`
3. **Right-click** on `logs/test_calls.log` → **Permissions** → `666`

---

## 🧪 Step 4: Test the API

### 4.1 Test Web Dashboard
**Visit:** `https://princedevops.live/dizzcall-ai-test-api/dashboard`

You should see:
- ✅ System Status: Operational
- ⚡ Response Time: ~1000ms
- 📊 Success Rate: 100%

### 4.2 Test API Endpoints

**Test Connection:**
```bash
curl https://princedevops.live/dizzcall-ai-test-api/connection
```

**Test Phone Simulation:**
```bash
curl -X POST https://princedevops.live/dizzcall-ai-test-api/simulate-call \
  -H "Content-Type: application/json" \
  -d '{
    "caller_phone": "+1234567890",
    "message": "Hello, I need help with your services",
    "conversation_type": "general"
  }'
```

---

## 🎯 Step 5: Client Integration

### 5.1 Share with Client
**Send these URLs to your client:**

1. **Test Dashboard:** `https://princedevops.live/dizzcall-ai-test-api/dashboard`
2. **API Base URL:** `https://princedevops.live/dizzcall-ai-test-api/`

### 5.2 API Documentation
**Share this documentation:**
```markdown
# DizzCall AI Test API

## Base URL
https://princedevops.live/dizzcall-ai-test-api/

## Quick Test
1. Visit: https://princedevops.live/dizzcall-ai-test-api/dashboard
2. Click "Test Connection" to verify AI is working
3. Use "Phone Call Simulator" to test conversations
4. Try "Quick Test Messages" for common scenarios

## API Endpoints
- GET /connection - Test AI system
- POST /simulate-call - Simulate phone call
- POST /test-responses - Test multiple messages
- GET /performance - Get system metrics
- GET /scenarios - Test predefined scenarios
```

---

## 📞 Step 6: Real Phone Integration

### 6.1 For Client's Dialer
When your client's dialer redirects calls, they should use:

**Phone Number:** `+16084969211`
**Webhook URL:** `https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/incoming`

### 6.2 Test Real Calls
1. **Call** `+16084969211`
2. **Speak** to the AI
3. **Check** the test API dashboard for logs

---

## 🔧 Step 7: Monitoring and Maintenance

### 7.1 Check Logs
**View test logs:**
- File: `/public_html/dizzcall-ai-test-api/logs/test_calls.log`
- Contains all test conversations
- Useful for debugging and analysis

### 7.2 Monitor Performance
**Check dashboard regularly:**
- Response times
- Success rates
- System status

### 7.3 Update Configuration
**Edit** `config.php` to:
- Change AI responses
- Update company information
- Modify conversation contexts

---

## 🚨 Troubleshooting

### Common Issues

**1. 500 Internal Server Error**
- Check file permissions (755 for folders, 644 for files)
- Verify PHP version (7.4+ required)
- Check error logs in cPanel

**2. AI Not Responding**
- Verify Gemini API key in config.php
- Check internet connection
- Verify API quota limits

**3. Dashboard Not Loading**
- Check .htaccess file exists
- Verify mod_rewrite is enabled
- Check file permissions

**4. CORS Issues**
- Verify .htaccess CORS headers
- Check server configuration

### Debug Steps
1. **Check PHP Error Logs** in cPanel
2. **Test API directly** with curl/Postman
3. **Verify file permissions**
4. **Check server requirements**

---

## ✅ Deployment Checklist

- [ ] Deployment package created
- [ ] Files uploaded to cPanel
- [ ] Files extracted correctly
- [ ] Permissions set (755/644)
- [ ] Web dashboard accessible
- [ ] API endpoints working
- [ ] AI responses functional
- [ ] Client URLs shared
- [ ] Documentation provided
- [ ] Real phone integration tested

---

## 🎉 Success!

Your standalone AI test API is now live at:
**`https://princedevops.live/dizzcall-ai-test-api/dashboard`**

### What Your Client Can Do:
1. **Test AI responses** in real-time
2. **Simulate phone calls** with different scenarios
3. **Check system performance** and metrics
4. **Integrate with their dialer** using the webhook URL
5. **Monitor AI quality** through the dashboard

### Next Steps:
1. **Share the dashboard URL** with your client
2. **Provide API documentation** for technical integration
3. **Test real phone calls** to verify everything works
4. **Monitor performance** and make adjustments as needed

---

## 📞 Support

If you encounter any issues:
- **Check the logs** in `/logs/test_calls.log`
- **Verify configuration** in `config.php`
- **Test individual endpoints** with curl/Postman
- **Contact support** if problems persist

**🎯 Your AI test system is ready for client demonstration!**
