# 📞 Twilio Phone Integration Setup Guide

## 🚀 Quick Setup

### 1. Get Twilio Credentials
1. Sign up at [Twilio Console](https://console.twilio.com/)
2. Get your Account SID and Auth Token
3. Purchase a phone number

### 2. Configure Environment Variables
Add these to your `.env` file:

```env
# Twilio Configuration
TWILIO_ACCOUNT_SID=your_account_sid_here
TWILIO_AUTH_TOKEN=your_auth_token_here
TWILIO_PHONE_NUMBER=+1234567890
TWILIO_WEBHOOK_URL=https://yourdomain.com/api/twilio/webhook
```

### 3. Install Twilio SDK
```bash
composer require twilio/sdk
```

### 4. Configure Webhooks
In your Twilio Console:
- Set incoming webhook URL: `https://yourdomain.com/api/twilio/webhook/incoming`
- Set status callback URL: `https://yourdomain.com/api/twilio/webhook/status`

## 🎯 Features

### ✅ Incoming Calls
- AI greets callers with personalized messages
- Speech-to-text recognition
- AI processes speech and responds
- Continuous conversation flow

### ✅ Outbound Calls
- Make calls from the AI dashboard
- Custom messages for each call
- Real-time call status monitoring
- Call logging and analytics

### ✅ AI Integration
- Uses your Gemma 2B model
- Context-aware responses
- Contact information integration
- Conversation logging

## 🔧 Usage

### Making a Call
1. Click the "Call" button in the AI dashboard
2. Enter phone number (with country code)
3. Add optional message
4. Click "Make Call"
5. Monitor call status in real-time

### Receiving Calls
- Calls to your Twilio number are automatically handled
- AI greets callers and processes their speech
- Responses are generated using your AI model
- All conversations are logged

## 📊 Call Analytics
- Call duration tracking
- Success/failure rates
- Conversation transcripts
- Contact integration

## 🛠️ Advanced Configuration

### Voice Settings
```php
// config/twilio.php
'voice' => [
    'language' => 'en-US',
    'voice' => 'alice', // alice, man, woman
    'gender' => 'female',
    'speed' => 1.0,
    'pitch' => 1.0,
],
```

### AI Settings
```php
'ai' => [
    'enabled' => true,
    'model' => 'gemma:2b',
    'response_timeout' => 5,
    'max_tokens' => 100,
    'temperature' => 0.7,
],
```

## 🔒 Security
- Webhook authentication
- CSRF protection
- Rate limiting
- Call logging for audit

## 📱 Testing
1. Use Twilio's test credentials for development
2. Test with your own phone number first
3. Monitor logs for debugging
4. Use Twilio's call simulator

## 💰 Costs
- Phone number: ~$1/month
- Incoming calls: ~$0.02/minute
- Outbound calls: ~$0.02/minute
- SMS: ~$0.0075/message

## 🆘 Troubleshooting
- Check webhook URLs are accessible
- Verify Twilio credentials
- Monitor Laravel logs
- Test with Twilio's debugger

## 🎉 Ready to Go!
Your AI can now make and receive real phone calls! 🚀📞
