<?php

namespace App\Services\AI;

class SimpleResponseService
{
    /**
     * Generate simple responses without external API calls
     */
    public function generateResponse(string $message, array $context = [], string $conversationType = 'general'): array
    {
        $message = strtolower(trim($message));
        
        // Simple keyword-based responses
        if (strpos($message, 'hello') !== false || strpos($message, 'hi') !== false) {
            $response = "Hello! This is Alex from Dizaart Systems. How can I help you today?";
        } elseif (strpos($message, 'software') !== false || strpos($message, 'app') !== false) {
            $response = "We specialize in custom software development and mobile applications. What type of project are you working on?";
        } elseif (strpos($message, 'marketing') !== false || strpos($message, 'digital') !== false) {
            $response = "We offer comprehensive digital marketing services including SEO, social media, and content marketing. How can we help grow your business?";
        } elseif (strpos($message, 'support') !== false || strpos($message, 'help') !== false) {
            $response = "I'm here to help! We provide IT support, software maintenance, and technical assistance. What specific issue are you facing?";
        } elseif (strpos($message, 'price') !== false || strpos($message, 'cost') !== false) {
            $response = "Our pricing varies based on project scope and requirements. I'd be happy to provide a custom quote. Can you tell me more about your project?";
        } elseif (strpos($message, 'contact') !== false || strpos($message, 'email') !== false) {
            $response = "You can reach us at info@dizaartsystems.com or call our main number. We're available Monday through Friday, 9 AM to 6 PM.";
        } elseif (strpos($message, 'meeting') !== false || strpos($message, 'schedule') !== false) {
            $response = "I'd be happy to schedule a meeting with our team. What's your name, company, and what would you like to discuss?";
        } elseif (strpos($message, 'thanks') !== false || strpos($message, 'thank you') !== false) {
            $response = "You're very welcome! Is there anything else I can help you with today?";
        } elseif (strpos($message, 'bye') !== false || strpos($message, 'goodbye') !== false) {
            $response = "Thank you for calling Dizaart Systems! Have a great day and feel free to call us anytime.";
        } else {
            $response = "I understand you're interested in our services. We offer custom software development, mobile apps, digital marketing, and IT support. What specific area interests you most?";
        }
        
        return [
            'success' => true,
            'response' => $response,
            'usage' => [
                'prompt_tokens' => 0,
                'completion_tokens' => 0,
                'total_tokens' => 0
            ],
            'model' => 'simple-response'
        ];
    }
    
    /**
     * Generate CRM-specific responses
     */
    public function generateCRMResponse(string $message, array $contactData = [], string $callType = 'sales'): array
    {
        $context = [];
        
        if (!empty($contactData)) {
            $context[] = "Contact: " . ($contactData['name'] ?? 'Unknown');
            $context[] = "Phone: " . ($contactData['phone'] ?? 'Unknown');
            $context[] = "Company: " . ($contactData['company'] ?? 'Unknown');
        }
        
        $context[] = "Call Type: " . $callType;
        
        return $this->generateResponse($message, $context, 'crm');
    }
}

