<?php
/**
 * DizzCall AI - cPanel Quick Setup Script
 * Run this after uploading files to cPanel
 */

echo "<h1>🚀 DizzCall AI - cPanel Setup</h1>";

// Check if we're in the right directory
if (!file_exists('artisan')) {
    die("<p style='color: red;'>❌ Error: Please run this script from the root directory of your Laravel application.</p>");
}

echo "<h2>📋 Setup Checklist:</h2>";

// 1. Check .env file
echo "<h3>1. Environment Configuration</h3>";
if (file_exists('.env')) {
    echo "<p style='color: green;'>✅ .env file exists</p>";
    
    // Check if APP_KEY is set
    $envContent = file_get_contents('.env');
    if (strpos($envContent, 'APP_KEY=') !== false && strpos($envContent, 'APP_KEY=') < strpos($envContent, 'APP_KEY=base64:')) {
        echo "<p style='color: orange;'>⚠️ APP_KEY needs to be generated</p>";
        echo "<p>Run: <code>php artisan key:generate</code></p>";
    } else {
        echo "<p style='color: green;'>✅ APP_KEY is configured</p>";
    }
} else {
    echo "<p style='color: red;'>❌ .env file not found</p>";
    echo "<p>Please create .env file from .env.example</p>";
}

// 2. Check database connection
echo "<h3>2. Database Connection</h3>";
try {
    $pdo = new PDO(
        'mysql:host=' . env('DB_HOST', 'localhost') . ';dbname=' . env('DB_DATABASE', 'laravel'),
        env('DB_USERNAME', 'root'),
        env('DB_PASSWORD', '')
    );
    echo "<p style='color: green;'>✅ Database connection successful</p>";
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Database connection failed: " . $e->getMessage() . "</p>";
    echo "<p>Please check your database credentials in .env file</p>";
}

// 3. Check storage permissions
echo "<h3>3. File Permissions</h3>";
$storageWritable = is_writable('storage');
$bootstrapCacheWritable = is_writable('bootstrap/cache');

if ($storageWritable) {
    echo "<p style='color: green;'>✅ Storage directory is writable</p>";
} else {
    echo "<p style='color: red;'>❌ Storage directory is not writable</p>";
    echo "<p>Run: <code>chmod -R 755 storage/</code></p>";
}

if ($bootstrapCacheWritable) {
    echo "<p style='color: green;'>✅ Bootstrap cache directory is writable</p>";
} else {
    echo "<p style='color: red;'>❌ Bootstrap cache directory is not writable</p>";
    echo "<p>Run: <code>chmod -R 755 bootstrap/cache/</code></p>";
}

// 4. Check required PHP extensions
echo "<h3>4. PHP Extensions</h3>";
$requiredExtensions = ['pdo', 'pdo_mysql', 'openssl', 'mbstring', 'tokenizer', 'xml', 'curl', 'json'];
$allExtensionsOk = true;

foreach ($requiredExtensions as $ext) {
    if (extension_loaded($ext)) {
        echo "<p style='color: green;'>✅ $ext extension loaded</p>";
    } else {
        echo "<p style='color: red;'>❌ $ext extension not loaded</p>";
        $allExtensionsOk = false;
    }
}

// 5. Check Twilio configuration
echo "<h3>5. Twilio Configuration</h3>";
$twilioSid = env('TWILIO_ACCOUNT_SID');
$twilioToken = env('TWILIO_AUTH_TOKEN');
$twilioPhone = env('TWILIO_PHONE_NUMBER');

if ($twilioSid && $twilioToken && $twilioPhone) {
    echo "<p style='color: green;'>✅ Twilio credentials configured</p>";
} else {
    echo "<p style='color: red;'>❌ Twilio credentials missing</p>";
    echo "<p>Please add TWILIO_ACCOUNT_SID, TWILIO_AUTH_TOKEN, and TWILIO_PHONE_NUMBER to .env</p>";
}

// 6. Check Gemini API
echo "<h3>6. AI Configuration</h3>";
$geminiKey = env('GEMINI_API_KEY');
if ($geminiKey) {
    echo "<p style='color: green;'>✅ Gemini API key configured</p>";
} else {
    echo "<p style='color: red;'>❌ Gemini API key missing</p>";
    echo "<p>Please add GEMINI_API_KEY to .env</p>";
}

// 7. Test routes
echo "<h3>7. Application Routes</h3>";
$routes = [
    'AI Dashboard' => '/ai-test-dashboard',
    'Twilio Incoming' => '/api/twilio/webhook/incoming',
    'Twilio Speech' => '/api/twilio/webhook/speech',
    'AI Stream' => '/ai-stream-words'
];

foreach ($routes as $name => $route) {
    $fullUrl = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . $route;
    echo "<p><strong>$name:</strong> <a href='$route' target='_blank'>$fullUrl</a></p>";
}

// 8. Next steps
echo "<h2>🎯 Next Steps:</h2>";
echo "<ol>";
echo "<li>If any issues are shown above, fix them first</li>";
echo "<li>Run: <code>php artisan key:generate</code></li>";
echo "<li>Run: <code>php artisan migrate</code></li>";
echo "<li>Run: <code>php artisan config:cache</code></li>";
echo "<li>Test your AI dashboard</li>";
echo "<li>Update Twilio webhooks to: <code>https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/</code></li>";
echo "<li>Test phone calls</li>";
echo "</ol>";

echo "<h2>📞 Test Your System:</h2>";
echo "<p><strong>AI Dashboard:</strong> <a href='/ai-test-dashboard' target='_blank'>Test AI Chat</a></p>";
echo "<p><strong>Phone System:</strong> Call <strong>+16084969211</strong></p>";
echo "<p><strong>Live URL:</strong> <a href='/' target='_blank'>https://princedevops.live/dizzcall-ai/public/</a></p>";

echo "<hr>";
echo "<p><em>DizzCall AI - Professional Voice CRM System</em></p>";
echo "<p><em>Deployed on: " . date('Y-m-d H:i:s') . "</em></p>";
?>
