@echo off
echo 🚀 DizzCall AI - Main Project Deployment Preparation
echo ==================================================

REM Create deployment directory
set DEPLOY_DIR=dizzcall-ai-main
echo 📁 Creating deployment directory: %DEPLOY_DIR%
if exist %DEPLOY_DIR% rmdir /s /q %DEPLOY_DIR%
mkdir %DEPLOY_DIR%

REM Copy essential Laravel files and folders
echo 📋 Copying Laravel application files...

REM Core Laravel files
copy artisan %DEPLOY_DIR%\
copy composer.json %DEPLOY_DIR%\
copy composer.lock %DEPLOY_DIR%\
copy package.json %DEPLOY_DIR%\
copy package-lock.json %DEPLOY_DIR%\
copy phpunit.xml %DEPLOY_DIR%\
copy vite.config.js %DEPLOY_DIR%\
copy production.env %DEPLOY_DIR%\.env

REM Copy directories
echo 📁 Copying application directories...
xcopy /E /I app %DEPLOY_DIR%\app
xcopy /E /I bootstrap %DEPLOY_DIR%\bootstrap
xcopy /E /I config %DEPLOY_DIR%\config
xcopy /E /I database %DEPLOY_DIR%\database
xcopy /E /I resources %DEPLOY_DIR%\resources
xcopy /E /I routes %DEPLOY_DIR%\routes
xcopy /E /I storage %DEPLOY_DIR%\storage
xcopy /E /I vendor %DEPLOY_DIR%\vendor

REM Copy public directory contents
echo 📁 Copying public directory...
mkdir %DEPLOY_DIR%\public
xcopy /E /I public\* %DEPLOY_DIR%\public\

REM Create .htaccess for public directory
echo 📝 Creating .htaccess for public directory...
echo ^<IfModule mod_rewrite.c^> > %DEPLOY_DIR%\public\.htaccess
echo     ^<IfModule mod_negotiation.c^> >> %DEPLOY_DIR%\public\.htaccess
echo         Options -MultiViews -Indexes >> %DEPLOY_DIR%\public\.htaccess
echo     ^</IfModule^> >> %DEPLOY_DIR%\public\.htaccess
echo. >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteEngine On >> %DEPLOY_DIR%\public\.htaccess
echo. >> %DEPLOY_DIR%\public\.htaccess
echo     # Handle Authorization Header >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteCond %%{HTTP:Authorization} . >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteRule .* - [E=HTTP_AUTHORIZATION:%%{HTTP:Authorization}] >> %DEPLOY_DIR%\public\.htaccess
echo. >> %DEPLOY_DIR%\public\.htaccess
echo     # Redirect Trailing Slashes If Not A Folder... >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteCond %%{REQUEST_FILENAME} !-d >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteCond %%{REQUEST_URI} ^(.+)/$ >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteRule ^ %%1 [L,R=301] >> %DEPLOY_DIR%\public\.htaccess
echo. >> %DEPLOY_DIR%\public\.htaccess
echo     # Send Requests To Front Controller... >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteCond %%{REQUEST_FILENAME} !-d >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteCond %%{REQUEST_FILENAME} !-f >> %DEPLOY_DIR%\public\.htaccess
echo     RewriteRule ^ index.php [L] >> %DEPLOY_DIR%\public\.htaccess
echo ^</IfModule^> >> %DEPLOY_DIR%\public\.htaccess

REM Create main .htaccess for subdirectory
echo 📝 Creating main .htaccess...
echo ^<IfModule mod_rewrite.c^> > %DEPLOY_DIR%\.htaccess
echo     RewriteEngine On >> %DEPLOY_DIR%\.htaccess
echo. >> %DEPLOY_DIR%\.htaccess
echo     # Redirect to public directory >> %DEPLOY_DIR%\.htaccess
echo     RewriteCond %%{REQUEST_URI} !^/dizzcall-ai/public/ >> %DEPLOY_DIR%\.htaccess
echo     RewriteRule ^(.*)$ /dizzcall-ai/public/$1 [L,R=301] >> %DEPLOY_DIR%\.htaccess
echo ^</IfModule^> >> %DEPLOY_DIR%\.htaccess

REM Create setup script
echo 📝 Creating setup script...
echo ^<?php > %DEPLOY_DIR%\setup.php
echo /** >> %DEPLOY_DIR%\setup.php
echo  * DizzCall AI - cPanel Setup Script >> %DEPLOY_DIR%\setup.php
echo  */ >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo echo "🚀 DizzCall AI - cPanel Setup"; >> %DEPLOY_DIR%\setup.php
echo echo "============================="; >> %DEPLOY_DIR%\setup.php
echo echo ""; >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo // Check if we're in the right directory >> %DEPLOY_DIR%\setup.php
echo if ^(!file_exists('artisan'^)^) { >> %DEPLOY_DIR%\setup.php
echo     die("❌ Error: Please run this script from the root directory of your Laravel application."); >> %DEPLOY_DIR%\setup.php
echo } >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo echo "📋 Setup Checklist:"; >> %DEPLOY_DIR%\setup.php
echo echo ""; >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo // 1. Check .env file >> %DEPLOY_DIR%\setup.php
echo echo "1. Environment Configuration"; >> %DEPLOY_DIR%\setup.php
echo if ^(file_exists('.env'^)^) { >> %DEPLOY_DIR%\setup.php
echo     echo "✅ .env file exists"; >> %DEPLOY_DIR%\setup.php
echo } else { >> %DEPLOY_DIR%\setup.php
echo     echo "❌ .env file not found - Please create .env file from production.env"; >> %DEPLOY_DIR%\setup.php
echo } >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo // 2. Check storage permissions >> %DEPLOY_DIR%\setup.php
echo echo "2. File Permissions"; >> %DEPLOY_DIR%\setup.php
echo $storageWritable = is_writable('storage'^); >> %DEPLOY_DIR%\setup.php
echo $bootstrapCacheWritable = is_writable('bootstrap/cache'^); >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo if ^($storageWritable^) { >> %DEPLOY_DIR%\setup.php
echo     echo "✅ Storage directory is writable"; >> %DEPLOY_DIR%\setup.php
echo } else { >> %DEPLOY_DIR%\setup.php
echo     echo "❌ Storage directory is not writable - Set permissions to 755"; >> %DEPLOY_DIR%\setup.php
echo } >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo if ^($bootstrapCacheWritable^) { >> %DEPLOY_DIR%\setup.php
echo     echo "✅ Bootstrap cache directory is writable"; >> %DEPLOY_DIR%\setup.php
echo } else { >> %DEPLOY_DIR%\setup.php
echo     echo "❌ Bootstrap cache directory is not writable - Set permissions to 755"; >> %DEPLOY_DIR%\setup.php
echo } >> %DEPLOY_DIR%\setup.php
echo. >> %DEPLOY_DIR%\setup.php
echo echo ""; >> %DEPLOY_DIR%\setup.php
echo echo "🎯 Next Steps:"; >> %DEPLOY_DIR%\setup.php
echo echo "1. Set file permissions: chmod -R 755 storage/ bootstrap/cache/"; >> %DEPLOY_DIR%\setup.php
echo echo "2. Run: php artisan key:generate"; >> %DEPLOY_DIR%\setup.php
echo echo "3. Run: php artisan migrate"; >> %DEPLOY_DIR%\setup.php
echo echo "4. Run: php artisan config:cache"; >> %DEPLOY_DIR%\setup.php
echo echo "5. Test your application at: https://princedevops.live/dizzcall-ai/public/"; >> %DEPLOY_DIR%\setup.php
echo echo ""; >> %DEPLOY_DIR%\setup.php
echo echo "📞 Test URLs:"; >> %DEPLOY_DIR%\setup.php
echo echo "- Main App: https://princedevops.live/dizzcall-ai/public/"; >> %DEPLOY_DIR%\setup.php
echo echo "- AI Dashboard: https://princedevops.live/dizzcall-ai/public/ai-test-dashboard"; >> %DEPLOY_DIR%\setup.php
echo echo "- Phone System: Call +16084969211"; >> %DEPLOY_DIR%\setup.php
echo ^?^> >> %DEPLOY_DIR%\setup.php

REM Create zip file
echo 📦 Creating deployment package...
powershell Compress-Archive -Path %DEPLOY_DIR%\* -DestinationPath dizzcall-ai-main.zip -Force

REM Cleanup
echo 🧹 Cleaning up...
rmdir /s /q %DEPLOY_DIR%

echo.
echo ✅ Main project package created: dizzcall-ai-main.zip
echo.
echo 📋 Next steps:
echo 1. Upload dizzcall-ai-main.zip to your cPanel File Manager
echo 2. Extract it in public_html/dizzcall-ai/
echo 3. Set file permissions (755 for folders, 644 for files)
echo 4. Run setup.php to check configuration
echo 5. Run Laravel commands in cPanel Terminal
echo.
echo 🎯 Your main DizzCall AI project will be live at:
echo https://princedevops.live/dizzcall-ai/public/
echo.
echo 🎉 Ready for deployment!
pause
