#!/bin/bash

# DizzCall AI - cPanel Deployment Script
# Run this script to prepare your files for cPanel deployment

echo "🚀 Preparing DizzCall AI for cPanel deployment..."

# Create production .env file
echo "📝 Creating production .env file..."
cat > .env.production << 'EOF'
APP_NAME="DizzCall AI"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://princedevops.live/dizzcall-ai/public

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

# Database Configuration for cPanel
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=princedevops_dizzcall_ai
DB_USERNAME=princedevops_8076
DB_PASSWORD=1qaz!QAZ@123

# Cache Configuration
BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

# Mail Configuration for princedevops.live
MAIL_MAILER=smtp
MAIL_HOST=mail.princedevops.live
MAIL_PORT=587
MAIL_USERNAME=noreply@princedevops.live
MAIL_PASSWORD=your_email_password_here
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@princedevops.live
MAIL_FROM_NAME="${APP_NAME}"

# Twilio Configuration
TWILIO_ACCOUNT_SID=ACba8ab371660f38e4427e334cc0c4a7fc
TWILIO_AUTH_TOKEN=b606503f25ce1f2115dc8aec158ce90b
TWILIO_PHONE_NUMBER=+16084969211
TWILIO_WEBHOOK_URL=https://princedevops.live/dizzcall-ai/public/api/twilio/webhook

# Gemini AI Configuration
GEMINI_API_KEY=AIzaSyA90MNxC9K8aOh9u9sRHpHba55pfDK2QoM

# AI Configuration
AI_MAX_TOKENS=20
AI_TEMPERATURE=0.1
AI_TIMEOUT=1
EOF

echo "✅ Production .env file created"

# Create deployment package
echo "📦 Creating deployment package..."
mkdir -p dizzcall-ai-deployment

# Copy necessary files
echo "📁 Copying application files..."
cp -r app dizzcall-ai-deployment/
cp -r bootstrap dizzcall-ai-deployment/
cp -r config dizzcall-ai-deployment/
cp -r database dizzcall-ai-deployment/
cp -r resources dizzcall-ai-deployment/
cp -r routes dizzcall-ai-deployment/
cp -r storage dizzcall-ai-deployment/
cp -r vendor dizzcall-ai-deployment/
cp artisan dizzcall-ai-deployment/
cp composer.json dizzcall-ai-deployment/
cp composer.lock dizzcall-ai-deployment/
cp .env.production dizzcall-ai-deployment/.env

# Copy .htaccess files
echo "📄 Copying .htaccess files..."
cp .htaccess-root dizzcall-ai-deployment/.htaccess
cp .htaccess-public dizzcall-ai-deployment/public/.htaccess

# Copy test files
echo "🧪 Copying test files..."
cp public/cpanel-deployment-test.php dizzcall-ai-deployment/public/
cp public/cpanel-setup.php dizzcall-ai-deployment/public/

# Create public folder
echo "📁 Creating public folder..."
mkdir -p dizzcall-ai-deployment/public
cp -r public/* dizzcall-ai-deployment/public/

# Create .htaccess for public folder
echo "⚙️ Creating .htaccess for public folder..."
cat > dizzcall-ai-deployment/public/.htaccess << 'EOF'
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
EOF

# Update index.php for production
echo "🔧 Updating index.php for production..."
cat > dizzcall-ai-deployment/public/index.php << 'EOF'
<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Adjust this path to your Laravel installation
require __DIR__.'/../../vendor/autoload.php';

$app = require_once __DIR__.'/../../bootstrap/app.php';

$kernel = $app->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response);
EOF

# Create deployment instructions
echo "📋 Creating deployment instructions..."
cat > dizzcall-ai-deployment/DEPLOYMENT_INSTRUCTIONS.txt << 'EOF'
DIZZCALL AI - CPANEL DEPLOYMENT INSTRUCTIONS
============================================

1. UPLOAD FILES:
   - Upload the entire 'dizzcall-ai-deployment' folder to your cPanel File Manager
   - Place it in: public_html/dizzcall-ai/

2. DATABASE SETUP:
   - Create database: princedevops_dizzcall
   - Create user: princedevops_user
   - Assign user to database with ALL PRIVILEGES
   - Update .env file with correct database credentials

3. GENERATE APP KEY:
   - Via cPanel Terminal: cd /home/princedevops/public_html/dizzcall-ai
   - Run: php artisan key:generate

4. RUN MIGRATIONS:
   - Run: php artisan migrate

5. SET PERMISSIONS:
   - chmod -R 755 storage/
   - chmod -R 755 bootstrap/cache/

6. UPDATE TWILIO WEBHOOKS:
   - Voice: https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/incoming
   - Status: https://princedevops.live/dizzcall-ai/public/api/twilio/webhook/outbound

7. TEST:
   - Visit: https://princedevops.live/dizzcall-ai/public/
   - Test AI: https://princedevops.live/dizzcall-ai/public/ai-test-dashboard
   - Call: +16084969211

Your DizzCall AI system will be live at:
https://princedevops.live/dizzcall-ai/public/
EOF

echo "✅ Deployment package created successfully!"
echo ""
echo "📁 Files ready in: dizzcall-ai-deployment/"
echo "📋 Instructions: dizzcall-ai-deployment/DEPLOYMENT_INSTRUCTIONS.txt"
echo ""
echo "🚀 Next steps:"
echo "1. Upload dizzcall-ai-deployment/ to your cPanel File Manager"
echo "2. Follow the instructions in DEPLOYMENT_INSTRUCTIONS.txt"
echo "3. Your AI system will be live at: https://princedevops.live/dizzcall-ai/public/"
echo ""
echo "📞 Test your phone system by calling: +16084969211"
