@echo off
echo 🚀 DizzCall AI Dialer API - Deployment Preparation
echo ================================================

REM Create deployment directory
set DEPLOY_DIR=dizzcall-ai-dialer-api
echo 📁 Creating deployment directory: %DEPLOY_DIR%
if exist %DEPLOY_DIR% rmdir /s /q %DEPLOY_DIR%
mkdir %DEPLOY_DIR%

REM Copy files
echo 📋 Copying files...
copy index.php %DEPLOY_DIR%\
copy .htaccess %DEPLOY_DIR%\

REM Create logs directory
echo 📝 Creating logs directory...
mkdir %DEPLOY_DIR%\logs
echo. > %DEPLOY_DIR%\logs\dialer_calls.log
echo. > %DEPLOY_DIR%\logs\errors.log

REM Create zip file
echo 📦 Creating deployment package...
powershell Compress-Archive -Path %DEPLOY_DIR%\* -DestinationPath dizzcall-ai-dialer-api.zip -Force

REM Cleanup
echo 🧹 Cleaning up...
rmdir /s /q %DEPLOY_DIR%

echo.
echo ✅ Dialer API package created: dizzcall-ai-dialer-api.zip
echo.
echo 📋 Next steps:
echo 1. Upload dizzcall-ai-dialer-api.zip to your cPanel File Manager
echo 2. Extract it in public_html/
echo 3. Test the webhook endpoints
echo 4. Share webhook URLs with your senior for dialer integration
echo.
echo 🎯 Webhook URLs for dialer integration:
echo - Incoming: https://princedevops.live/dizzcall-ai-dialer-api/webhook/incoming
echo - Speech: https://princedevops.live/dizzcall-ai-dialer-api/webhook/speech
echo - Outbound: https://princedevops.live/dizzcall-ai-dialer-api/webhook/outbound
echo.
echo 🎉 Ready for dialer integration!
pause
