<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Test - DizzCall AI</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .test-container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 100%;
            text-align: center;
        }

        .test-header h1 {
            color: #4f46e5;
            font-size: 28px;
            margin-bottom: 10px;
        }

        .test-header p {
            color: #6b7280;
            font-size: 16px;
            margin-bottom: 30px;
        }

        .test-button {
            background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin: 10px;
            text-decoration: none;
            display: inline-block;
        }

        .test-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(79, 70, 229, 0.3);
        }

        .result {
            margin-top: 20px;
            padding: 15px;
            border-radius: 8px;
            font-weight: 500;
        }

        .result.success {
            background: #d1fae5;
            color: #065f46;
            border: 1px solid #a7f3d0;
        }

        .result.error {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fca5a5;
        }

        .config-info {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            text-align: left;
        }

        .config-info h3 {
            color: #374151;
            margin-bottom: 10px;
            font-size: 16px;
        }

        .config-item {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
            font-size: 14px;
        }

        .config-label {
            color: #6b7280;
            font-weight: 500;
        }

        .config-value {
            color: #374151;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <div class="test-container">
        <div class="test-header">
            <h1>📧 Email Test</h1>
            <p>Test the email configuration for DizzCall AI</p>
        </div>

        <div class="config-info">
            <h3>Current Configuration:</h3>
            <div class="config-item">
                <span class="config-label">SMTP Host:</span>
                <span class="config-value">smtp.gmail.com</span>
            </div>
            <div class="config-item">
                <span class="config-label">Port:</span>
                <span class="config-value">587</span>
            </div>
            <div class="config-item">
                <span class="config-label">From Email:</span>
                <span class="config-value">dizaartsystem@gmail.com</span>
            </div>
            <div class="config-item">
                <span class="config-label">From Name:</span>
                <span class="config-value">Dizcall Ai</span>
            </div>
        </div>

        <a href="/test-email" class="test-button" target="_blank">
            🚀 Send Test Email
        </a>

        <a href="/test-welcome-email" class="test-button" target="_blank">
            👤 Test Welcome Email
        </a>

        <div style="margin-top: 30px; padding: 20px; background: #f0f9ff; border-radius: 8px; text-align: left;">
            <h4 style="color: #0369a1; margin-bottom: 10px;">📋 Instructions:</h4>
            <ol style="color: #374151; font-size: 14px; line-height: 1.6;">
                <li>Click "Send Test Email" to test basic email functionality</li>
                <li>Click "Test Welcome Email" to test the user welcome template</li>
                <li>Check your Gmail inbox at <strong>dizaartsystem@gmail.com</strong></li>
                <li>If emails are received, your system is working correctly!</li>
            </ol>
        </div>

        <div style="margin-top: 20px; padding: 15px; background: #fef3c7; border-radius: 8px;">
            <p style="color: #92400e; font-size: 14px; margin: 0;">
                <strong>Note:</strong> If you don't receive emails, check your spam folder or verify your Gmail app password is correct.
            </p>
        </div>
    </div>
</body>
</html>