<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset OTP</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }
        .content {
            padding: 40px 30px;
        }
        .otp-container {
            background: #f8f9fa;
            border: 2px dashed #dee2e6;
            border-radius: 10px;
            padding: 30px;
            text-align: center;
            margin: 30px 0;
        }
        .otp-code {
            font-size: 36px;
            font-weight: bold;
            color: #2c3e50;
            letter-spacing: 8px;
            margin: 20px 0;
            padding: 15px;
            background: white;
            border-radius: 8px;
            border: 2px solid #e9ecef;
            display: inline-block;
            min-width: 200px;
        }
        .otp-label {
            font-size: 16px;
            color: #6c757d;
            margin-bottom: 10px;
        }
        .expiry-info {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #856404;
        }
        .security-note {
            background: #d1ecf1;
            border: 1px solid #bee5eb;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #0c5460;
        }
        .button {
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 25px;
            font-weight: 600;
            margin: 20px 0;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px 30px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
        }
        .footer a {
            color: #667eea;
            text-decoration: none;
        }
        .divider {
            height: 1px;
            background: #e9ecef;
            margin: 30px 0;
        }
        .icon {
            font-size: 48px;
            color: #667eea;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔐 Password Reset Request</h1>
            <p style="margin: 10px 0 0 0; opacity: 0.9;">DizzCall AI - Secure Account Recovery</p>
        </div>
        
        <div class="content">
            <div style="text-align: center;">
                <div class="icon">🔑</div>
                <h2 style="color: #2c3e50; margin-bottom: 10px;">Password Reset OTP</h2>
                <p style="color: #6c757d; font-size: 16px;">Hello <strong><?php echo e($user->name); ?></strong>,</p>
                <p>We received a request to reset your password for your DizzCall AI account. Use the OTP below to verify your identity and reset your password.</p>
            </div>

            <div class="otp-container">
                <div class="otp-label">Your One-Time Password (OTP) is:</div>
                <div class="otp-code"><?php echo e($otp); ?></div>
                <p style="margin: 0; color: #6c757d; font-size: 14px;">Enter this code in the password reset form</p>
            </div>

            <div class="expiry-info">
                <strong>⏰ Important:</strong> This OTP will expire in <strong><?php echo e($expiryMinutes); ?> minutes</strong> for security reasons. If you don't use it within this time, you'll need to request a new one.
            </div>

            <div class="security-note">
                <strong>🛡️ Security Notice:</strong> If you didn't request this password reset, please ignore this email. Your account remains secure and no changes have been made.
            </div>

            <div class="divider"></div>

            <div style="text-align: center;">
                <p style="margin-bottom: 20px;">Click the button below to go to the password reset page:</p>
                <a href="<?php echo e($resetUrl); ?>" class="button">Reset My Password</a>
            </div>

            <div style="margin-top: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <h4 style="color: #2c3e50; margin-top: 0;">Need Help?</h4>
                <p style="margin-bottom: 10px;">If you're having trouble with the password reset process:</p>
                <ul style="text-align: left; color: #6c757d;">
                    <li>Make sure you're using the correct email address</li>
                    <li>Check your spam/junk folder if you don't see this email</li>
                    <li>Contact our support team if you continue to have issues</li>
                </ul>
            </div>
        </div>

        <div class="footer">
            <p style="margin: 0 0 10px 0;">
                <strong>DizzCall AI</strong> - Advanced Call Management System
            </p>
            <p style="margin: 0; font-size: 12px;">
                This email was sent to <?php echo e($user->email); ?>. If you have any questions, please contact our support team.
            </p>
            <p style="margin: 10px 0 0 0; font-size: 12px;">
                © <?php echo e(date('Y')); ?> DizzCall AI. All rights reserved.
            </p>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/emails/password-reset-otp.blade.php ENDPATH**/ ?>