@echo off
echo 🚀 DizzCall AI Test API - Deployment Preparation
echo ================================================

REM Create deployment directory
set DEPLOY_DIR=dizzcall-ai-test-api
echo 📁 Creating deployment directory: %DEPLOY_DIR%
if exist %DEPLOY_DIR% rmdir /s /q %DEPLOY_DIR%
mkdir %DEPLOY_DIR%

REM Copy files
echo 📋 Copying files...
copy index.php %DEPLOY_DIR%\
copy dashboard.html %DEPLOY_DIR%\
copy config.php %DEPLOY_DIR%\
copy .htaccess %DEPLOY_DIR%\
copy README.md %DEPLOY_DIR%\

REM Create logs directory
echo 📝 Creating logs directory...
mkdir %DEPLOY_DIR%\logs
echo. > %DEPLOY_DIR%\logs\test_calls.log

REM Create zip file
echo 📦 Creating deployment package...
powershell Compress-Archive -Path %DEPLOY_DIR%\* -DestinationPath dizzcall-ai-test-api.zip -Force

REM Cleanup
echo 🧹 Cleaning up...
rmdir /s /q %DEPLOY_DIR%

echo.
echo ✅ Deployment package created: dizzcall-ai-test-api.zip
echo.
echo 📋 Next steps:
echo 1. Upload dizzcall-ai-test-api.zip to your cPanel File Manager
echo 2. Extract it in public_html/
echo 3. Visit https://yourdomain.com/dizzcall-ai-test-api/dashboard
echo 4. Test the AI system!
echo.
echo 🎉 Ready for deployment!
pause
