#!/bin/bash

# DizzCall AI Test API - Deployment Script
# Run this script to prepare files for cPanel deployment

echo "🚀 DizzCall AI Test API - Deployment Preparation"
echo "================================================"

# Create deployment directory
DEPLOY_DIR="dizzcall-ai-test-api"
echo "📁 Creating deployment directory: $DEPLOY_DIR"
mkdir -p $DEPLOY_DIR

# Copy files
echo "📋 Copying files..."
cp index.php $DEPLOY_DIR/
cp dashboard.html $DEPLOY_DIR/
cp config.php $DEPLOY_DIR/
cp .htaccess $DEPLOY_DIR/
cp README.md $DEPLOY_DIR/

# Create logs directory
echo "📝 Creating logs directory..."
mkdir -p $DEPLOY_DIR/logs
touch $DEPLOY_DIR/logs/test_calls.log
chmod 666 $DEPLOY_DIR/logs/test_calls.log

# Set permissions
echo "🔐 Setting permissions..."
chmod 755 $DEPLOY_DIR/
chmod 644 $DEPLOY_DIR/index.php
chmod 644 $DEPLOY_DIR/dashboard.html
chmod 644 $DEPLOY_DIR/config.php
chmod 644 $DEPLOY_DIR/.htaccess
chmod 644 $DEPLOY_DIR/README.md

# Create zip file
echo "📦 Creating deployment package..."
zip -r dizzcall-ai-test-api.zip $DEPLOY_DIR/

# Cleanup
echo "🧹 Cleaning up..."
rm -rf $DEPLOY_DIR/

echo ""
echo "✅ Deployment package created: dizzcall-ai-test-api.zip"
echo ""
echo "📋 Next steps:"
echo "1. Upload dizzcall-ai-test-api.zip to your cPanel File Manager"
echo "2. Extract it in public_html/"
echo "3. Visit https://yourdomain.com/dizzcall-ai-test-api/dashboard"
echo "4. Test the AI system!"
echo ""
echo "🎉 Ready for deployment!"
