<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\AI\Phi3Service;

class TestAICommand extends Command
{
    protected $signature = 'ai:test';
    protected $description = 'Test AI connection and functionality';

    public function handle()
    {
        $this->info('🤖 Testing AI Connection...');
        $this->line('==========================');

        try {
            $phi3 = new Phi3Service();
            $result = $phi3->testConnection();
            
            if ($result['success']) {
                $this->info('✅ AI Connection Successful!');
                $this->line('Response: ' . ($result['details']['response'] ?? 'No response'));
            } else {
                $this->error('❌ AI Connection Failed!');
                $this->line('Error: ' . ($result['error'] ?? 'Unknown error'));
            }
            
            // Test a simple conversation
            $this->line('');
            $this->info('🧪 Testing AI Response...');
            $response = $phi3->generateResponse('Hello, I am interested in your AI voice agent service. Can you tell me more about it?');
            
            if ($response['success']) {
                $this->info('✅ AI Response Generated!');
                $this->line('Response: ' . $response['response']);
            } else {
                $this->error('❌ AI Response Failed!');
                $this->line('Error: ' . ($response['error'] ?? 'Unknown error'));
            }
            
        } catch (\Exception $e) {
            $this->error('❌ Error: ' . $e->getMessage());
        }
    }
}
