<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WalletRechargeMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $name;
    public float $amount;
    public float $balanceAfter;
    public ?string $paymentId;

    public function __construct(string $name, float $amount, float $balanceAfter, ?string $paymentId)
    {
        $this->name = $name;
        $this->amount = $amount;
        $this->balanceAfter = $balanceAfter;
        $this->paymentId = $paymentId;
    }

    public function build(): self
    {
        return $this->subject('Wallet Recharge Successful')
            ->view('emails.wallet_recharge');
    }
}


