<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Contact extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'company_name',
        'contact_number',
        'interactions',
        'user_id'
    ];

    protected $casts = [
        'interactions' => 'array'
    ];

    /**
     * Get the user who owns this contact
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get conversations for this contact
     */
    public function conversations()
    {
        return $this->hasMany(Conversation::class);
    }
}
