

<?php $__env->startSection('title', 'Add Funds to Wallet'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Wallet Balance</h5>
                    <span class="badge bg-primary fs-6">₹ <?php echo e(number_format($user->wallet_balance ?? 0, 2)); ?></span>
                </div>
                <div class="card-body">
                    <form id="topup-form">
                        <div class="mb-3">
                            <label for="amount" class="form-label">Amount (INR)</label>
                            <input type="number" min="1" step="1" class="form-control" id="amount" name="amount" placeholder="Enter amount" required>
                        </div>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-plus-circle me-1"></i> Add Funds
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
document.getElementById('topup-form').addEventListener('submit', async function (e) {
    e.preventDefault();
    const amount = document.getElementById('amount').value;

    const resp = await fetch("<?php echo e(route('wallet.order')); ?>", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({ amount })
    });

    if (!resp.ok) {
        alert('Unable to create order');
        return;
    }

    const data = await resp.json();

    const options = {
        key: data.key,
        amount: data.amount,
        currency: data.currency,
        name: '<?php echo e(config('app.name')); ?>',
        description: 'Wallet Top-up',
        order_id: data.order_id,
        handler: async function (response){
            const verifyResp = await fetch("<?php echo e(route('wallet.verify')); ?>", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({
                    razorpay_payment_id: response.razorpay_payment_id,
                    razorpay_order_id: response.razorpay_order_id,
                    razorpay_signature: response.razorpay_signature,
                    txn_id: data.txn_id
                })
            });

            if (verifyResp.ok) {
                location.reload();
            } else {
                alert('Verification failed');
            }
        },
        prefill: {
            name: '<?php echo e($user->name); ?>',
            email: '<?php echo e($user->email); ?>'
        },
        theme: { color: '#0d6efd' }
    };

    const rzp = new Razorpay(options);
    rzp.open();
});
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/wallet/topup.blade.php ENDPATH**/ ?>