<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('calls', function (Blueprint $table) {
            $table->id();
            $table->string('call_id')->nullable()->index();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('contact_name')->nullable();
            $table->string('phone_number')->nullable();
            $table->dateTime('date_time')->nullable();
            // store duration in seconds
            $table->integer('duration')->default(0);
            $table->decimal('cost', 12, 2)->default(0);
            $table->longText('transcript')->nullable();
            $table->longText('summary')->nullable();
            $table->string('status')->default('completed');
            $table->string('next_action')->nullable();
            $table->dateTime('follow_up_date')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'status']);
            $table->index(['date_time']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('calls');
    }
};



