<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conversations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->unsignedBigInteger('contact_id')->nullable();
            $table->string('session_id')->unique();
            $table->enum('type', ['sales', 'support', 'follow_up', 'qualification', 'demo', 'general'])->default('general');
            $table->enum('status', ['active', 'completed', 'paused', 'cancelled'])->default('active');
            $table->json('context_data')->nullable();
            $table->string('ai_model')->default('phi3-mini');
            $table->integer('total_messages')->default(0);
            $table->integer('duration_seconds')->default(0);
            $table->decimal('sentiment_score', 3, 2)->nullable();
            $table->decimal('satisfaction_score', 3, 2)->nullable();
            $table->string('outcome')->nullable();
            $table->text('summary')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('ended_at')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'status']);
            $table->index(['contact_id', 'type']);
            $table->index('session_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conversations');
    }
};
