<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ai_insights', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained()->onDelete('cascade');
            $table->foreignId('message_id')->nullable()->constrained('conversation_messages')->onDelete('cascade');
            $table->enum('insight_type', [
                'sentiment', 'intent', 'entity', 'action_item', 'next_step',
                'objection', 'interest', 'urgency', 'decision_maker', 'budget',
                'timeline', 'competitor', 'pain_point', 'solution', 'follow_up'
            ]);
            $table->text('content');
            $table->decimal('confidence_score', 3, 2);
            $table->json('metadata')->nullable();
            $table->timestamp('processed_at');
            $table->timestamps();
            
            $table->index(['conversation_id', 'insight_type']);
            $table->index(['confidence_score', 'processed_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ai_insights');
    }
};
