@extends('FrontUser.layouts.app')

@section('title', 'Reports & Analytics')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Call Reports & Analytics</h3>
                    <div class="card-tools">
                        <button class="btn btn-primary">
                            <i class="fas fa-download"></i> Export Report
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Calls</h5>
                                    <h2>{{ number_format($totalCalls ?? 0) }}</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Successful Calls</h5>
                                    <h2>{{ number_format($successfulCalls ?? 0) }}</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Duration</h5>
                                    @php($mins = (int) floor(($totalDurationSeconds ?? 0)/60))
                                    <h2>{{ $mins }}m</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Cost</h5>
                                    <h2>₹{{ number_format($totalCost ?? 0, 2) }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Call Volume (Last 30 Days)</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="volumeChart" height="120"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Call Distribution</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="distributionChart" height="120"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h5>Call History</h5>
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 200px;">
                                    <input type="text" name="table_search" class="form-control float-right" placeholder="Search">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-default">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Call ID</th>
                                            <th>From</th>
                                            <th>To</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Cost</th>
                                            <th>Date/Time</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($calls as $call)
                                        <tr>
                                            <td>{{ $call->call_id ?? $call->id }}</td>
                                            <td>{{ $call->from ?? '—' }}</td>
                                            <td>{{ $call->phone_number ?? $call->to ?? '—' }}</td>
                                            @php($dur = (int) ($call->duration ?? 0))
                                            <td>{{ sprintf('%02d:%02d', floor($dur/60), $dur%60) }}</td>
                                            <td><span class="badge {{ ($call->status==='completed') ? 'bg-success' : (($call->status==='failed')?'bg-danger':'bg-secondary') }}">{{ ucfirst($call->status ?? 'pending') }}</span></td>
                                            <td>₹{{ number_format((float)($call->cost ?? 0), 2) }}</td>
                                            <td>{{ optional($call->date_time)->format('d M, h:i A') }}</td>
                                            <td>
                                                <a class="btn btn-sm btn-info" title="View Details"><i class="fas fa-eye"></i></a>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="8" class="text-center text-muted">No calls found.</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer clearfix">
                            {{ $calls->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const labels = @json($labels30 ?? []);
    const calls = @json($calls30 ?? []);
    const spend = @json($spend30 ?? []);
    const statusCounts = @json($statusCounts ?? []);

    if (window.Chart) {
        const volumeCtx = document.getElementById('volumeChart');
        if (volumeCtx) {
            new Chart(volumeCtx, {
                type: 'line',
                data: { labels, datasets: [
                    { label: 'Calls', data: calls, borderColor: '#4361ee', backgroundColor: 'rgba(67,97,238,0.2)', fill: true },
                    { label: 'Spend (₹)', data: spend, borderColor: '#f72585', backgroundColor: 'rgba(247,37,133,0.15)', fill: true }
                ]},
                options: { responsive: true, plugins: { legend: { position: 'bottom' } }, scales: { y: { beginAtZero: true } } }
            });
        }

        const distCtx = document.getElementById('distributionChart');
        if (distCtx) {
            const statuses = Object.keys(statusCounts);
            const values = Object.values(statusCounts);
            new Chart(distCtx, {
                type: 'doughnut',
                data: {
                    labels: statuses,
                    datasets: [{ data: values, backgroundColor: ['#22c55e', '#ef4444', '#6b7280', '#f59e0b'] }]
                },
                options: { responsive: true, plugins: { legend: { position: 'bottom' } } }
            });
        }
    }
});
</script>
@endsection