@extends('FrontUser.layouts.app')

@section('title', 'Search')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="m-0">Search results for "{{ $q }}"</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6>Calls</h6>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Contact</th>
                                    <th>Phone</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($calls as $call)
                                <tr>
                                    <td>{{ $call->call_id ?? $call->id }}</td>
                                    <td>{{ $call->contact_name ?? '—' }}</td>
                                    <td>{{ $call->phone_number ?? '—' }}</td>
                                    <td>{{ optional($call->date_time)->format('d M, h:i A') }}</td>
                                </tr>
                                @empty
                                <tr><td colspan="4" class="text-muted">No calls found.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <h6>Transactions</h6>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $t)
                                <tr>
                                    <td>{{ $t->id }}</td>
                                    <td>{{ ucfirst($t->type) }}</td>
                                    <td>₹{{ number_format((float)$t->amount, 2) }}</td>
                                    <td>{{ optional($t->created_at)->format('d M, h:i A') }}</td>
                                </tr>
                                @empty
                                <tr><td colspan="4" class="text-muted">No transactions found.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


