<?php
// app/Http/Controllers/Auth/HomeController.php

namespace App\Http\Controllers\Auth;

use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Auth;
use App\Models\Call;
use App\Models\WalletTransaction;

class HomeController extends BaseController
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = Auth::user();

        $walletBalance = $user->wallet_balance ?? 0.0;
        $lastRecharge = WalletTransaction::where('user_id', $user->id)
            ->where('type', 'credit')
            ->where('status', 'success')
            ->latest('id')
            ->first();

        // Simple stats (adjust if you have separate tables/fields)
        $totalCalls = Call::where('user_id', $user->id)->count();
        $totalDurationSeconds = (int) Call::where('user_id', $user->id)->sum('duration');
        $totalMoney = (float) Call::where('user_id', $user->id)->sum('cost');

        $recentCalls = Call::where('user_id', $user->id)
            ->orderByDesc('date_time')
            ->take(5)
            ->get();

        $scheduledCalls = Call::where('user_id', $user->id)
            ->where('status', 'pending')
            ->orderBy('date_time')
            ->take(5)
            ->get();

        return view('home', compact(
            'user',
            'walletBalance',
            'lastRecharge',
            'totalCalls',
            'totalDurationSeconds',
            'totalMoney',
            'recentCalls',
            'scheduledCalls'
        ));
    }
}