<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserCredentialsMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $name;
    public string $userId;
    public string $email;
    public string $plainPassword;

    public function __construct(string $name, string $userId, string $email, string $plainPassword)
    {
        $this->name = $name;
        $this->userId = $userId;
        $this->email = $email;
        $this->plainPassword = $plainPassword;
    }

    public function build(): self
    {
        return $this->subject('Your DizzCall AI Account Credentials')
            ->view('emails.user_credentials');
    }
}


