<?php
// app/Models/Call.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Call extends Model
{
    use HasFactory;

    protected $fillable = [
        'call_id', 'user_id', 'contact_name', 'phone_number', 
        'date_time', 'duration', 'cost', 'transcript', 
        'summary', 'status', 'next_action', 'follow_up_date'
    ];

    protected $dates = ['date_time', 'follow_up_date'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}