<?php
/**
 * DizzCall AI - cPanel Deployment Test
 * Test all components after deployment
 */

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start output buffering
ob_start();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DizzCall AI - Deployment Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .test-section { margin: 20px 0; padding: 15px; border-radius: 5px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; }
        .warning { background: #fff3cd; border: 1px solid #ffeaa7; color: #856404; }
        .info { background: #d1ecf1; border: 1px solid #bee5eb; color: #0c5460; }
        h1 { color: #333; text-align: center; }
        h2 { color: #666; border-bottom: 2px solid #007bff; padding-bottom: 5px; }
        .test-item { margin: 10px 0; padding: 10px; border-left: 4px solid #007bff; background: #f8f9fa; }
        .status { font-weight: bold; }
        .pass { color: #28a745; }
        .fail { color: #dc3545; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 3px; font-family: monospace; margin: 10px 0; }
        .url-test { margin: 10px 0; }
        .url-test a { color: #007bff; text-decoration: none; }
        .url-test a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 DizzCall AI - Deployment Test</h1>
        <p><strong>Domain:</strong> princedevops.live</p>
        <p><strong>Test Time:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>

        <?php
        // Test 1: PHP Version
        echo '<div class="test-section">';
        echo '<h2>1. PHP Version Check</h2>';
        $phpVersion = phpversion();
        $phpRequired = '8.1';
        if (version_compare($phpVersion, $phpRequired, '>=')) {
            echo '<div class="test-item success"><span class="status pass">✓ PASS</span> PHP Version: ' . $phpVersion . ' (Required: ' . $phpRequired . '+)</div>';
        } else {
            echo '<div class="test-item error"><span class="status fail">✗ FAIL</span> PHP Version: ' . $phpVersion . ' (Required: ' . $phpRequired . '+)</div>';
        }
        echo '</div>';

        // Test 2: Required Extensions
        echo '<div class="test-section">';
        echo '<h2>2. Required PHP Extensions</h2>';
        $requiredExtensions = ['curl', 'json', 'mbstring', 'openssl', 'pdo', 'pdo_mysql', 'tokenizer', 'xml', 'zip'];
        $allExtensionsOk = true;
        
        foreach ($requiredExtensions as $ext) {
            if (extension_loaded($ext)) {
                echo '<div class="test-item success"><span class="status pass">✓</span> ' . $ext . '</div>';
            } else {
                echo '<div class="test-item error"><span class="status fail">✗</span> ' . $ext . ' (Missing)</div>';
                $allExtensionsOk = false;
            }
        }
        echo '</div>';

        // Test 3: File Permissions
        echo '<div class="test-section">';
        echo '<h2>3. File Permissions</h2>';
        $directories = ['storage', 'bootstrap/cache'];
        $permissionsOk = true;
        
        foreach ($directories as $dir) {
            if (is_dir($dir)) {
                if (is_writable($dir)) {
                    echo '<div class="test-item success"><span class="status pass">✓</span> ' . $dir . ' (Writable)</div>';
                } else {
                    echo '<div class="test-item error"><span class="status fail">✗</span> ' . $dir . ' (Not Writable)</div>';
                    $permissionsOk = false;
                }
            } else {
                echo '<div class="test-item error"><span class="status fail">✗</span> ' . $dir . ' (Directory Not Found)</div>';
                $permissionsOk = false;
            }
        }
        echo '</div>';

        // Test 4: Environment File
        echo '<div class="test-section">';
        echo '<h2>4. Environment Configuration</h2>';
        if (file_exists('.env')) {
            echo '<div class="test-item success"><span class="status pass">✓</span> .env file exists</div>';
            
            // Check key environment variables
            $envContent = file_get_contents('.env');
            $envVars = ['APP_URL', 'DB_DATABASE', 'DB_USERNAME', 'TWILIO_ACCOUNT_SID', 'GEMINI_API_KEY'];
            
            foreach ($envVars as $var) {
                if (strpos($envContent, $var) !== false) {
                    echo '<div class="test-item success"><span class="status pass">✓</span> ' . $var . ' configured</div>';
                } else {
                    echo '<div class="test-item error"><span class="status fail">✗</span> ' . $var . ' not found</div>';
                }
            }
        } else {
            echo '<div class="test-item error"><span class="status fail">✗</span> .env file not found</div>';
        }
        echo '</div>';

        // Test 5: Database Connection
        echo '<div class="test-section">';
        echo '<h2>5. Database Connection</h2>';
        try {
            // Load environment variables
            if (file_exists('.env')) {
                $lines = file('.env', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                foreach ($lines as $line) {
                    if (strpos($line, '=') !== false && strpos($line, '#') !== 0) {
                        list($key, $value) = explode('=', $line, 2);
                        $_ENV[trim($key)] = trim($value);
                    }
                }
            }
            
            $host = $_ENV['DB_HOST'] ?? 'localhost';
            $dbname = $_ENV['DB_DATABASE'] ?? 'princedevops_dizzcall_ai';
            $username = $_ENV['DB_USERNAME'] ?? 'princedevops_8076';
            $password = $_ENV['DB_PASSWORD'] ?? '1qaz!QAZ@123';
            
            $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
            echo '<div class="test-item success"><span class="status pass">✓</span> Database connection successful</div>';
            echo '<div class="test-item info">Database: ' . $dbname . '</div>';
            echo '<div class="test-item info">Host: ' . $host . '</div>';
            echo '<div class="test-item info">User: ' . $username . '</div>';
        } catch (PDOException $e) {
            echo '<div class="test-item error"><span class="status fail">✗</span> Database connection failed: ' . $e->getMessage() . '</div>';
        }
        echo '</div>';

        // Test 6: Laravel Application
        echo '<div class="test-section">';
        echo '<h2>6. Laravel Application</h2>';
        if (file_exists('artisan')) {
            echo '<div class="test-item success"><span class="status pass">✓</span> Laravel artisan file found</div>';
        } else {
            echo '<div class="test-item error"><span class="status fail">✗</span> Laravel artisan file not found</div>';
        }
        
        if (file_exists('composer.json')) {
            echo '<div class="test-item success"><span class="status pass">✓</span> Composer configuration found</div>';
        } else {
            echo '<div class="test-item error"><span class="status fail">✗</span> Composer configuration not found</div>';
        }
        echo '</div>';

        // Test 7: URL Tests
        echo '<div class="test-section">';
        echo '<h2>7. URL Accessibility Tests</h2>';
        $baseUrl = 'https://princedevops.live/dizzcall-ai/public';
        $testUrls = [
            'Main App' => $baseUrl . '/',
            'AI Dashboard' => $baseUrl . '/ai-test-dashboard',
            'Setup Check' => $baseUrl . '/cpanel-setup.php',
            'API Test' => $baseUrl . '/ai-phone-instant?message=test'
        ];
        
        foreach ($testUrls as $name => $url) {
            echo '<div class="url-test">';
            echo '<strong>' . $name . ':</strong> ';
            echo '<a href="' . $url . '" target="_blank">' . $url . '</a>';
            echo '</div>';
        }
        echo '</div>';

        // Test 8: Twilio Configuration
        echo '<div class="test-section">';
        echo '<h2>8. Twilio Configuration</h2>';
        $twilioSid = $_ENV['TWILIO_ACCOUNT_SID'] ?? '';
        $twilioToken = $_ENV['TWILIO_AUTH_TOKEN'] ?? '';
        $twilioPhone = $_ENV['TWILIO_PHONE_NUMBER'] ?? '';
        
        if (!empty($twilioSid) && !empty($twilioToken)) {
            echo '<div class="test-item success"><span class="status pass">✓</span> Twilio credentials configured</div>';
            echo '<div class="test-item info">Account SID: ' . substr($twilioSid, 0, 10) . '...</div>';
            echo '<div class="test-item info">Phone Number: ' . $twilioPhone . '</div>';
        } else {
            echo '<div class="test-item error"><span class="status fail">✗</span> Twilio credentials not configured</div>';
        }
        echo '</div>';

        // Test 9: AI Configuration
        echo '<div class="test-section">';
        echo '<h2>9. AI Configuration</h2>';
        $geminiKey = $_ENV['GEMINI_API_KEY'] ?? '';
        
        if (!empty($geminiKey)) {
            echo '<div class="test-item success"><span class="status pass">✓</span> Gemini API key configured</div>';
            echo '<div class="test-item info">API Key: ' . substr($geminiKey, 0, 10) . '...</div>';
        } else {
            echo '<div class="test-item error"><span class="status fail">✗</span> Gemini API key not configured</div>';
        }
        echo '</div>';

        // Summary
        echo '<div class="test-section">';
        echo '<h2>📋 Deployment Summary</h2>';
        echo '<div class="test-item info">';
        echo '<strong>Next Steps:</strong><br>';
        echo '1. If all tests pass, your deployment is ready!<br>';
        echo '2. Update Twilio webhooks to: ' . $baseUrl . '/api/twilio/webhook/incoming<br>';
        echo '3. Test phone system by calling: ' . $twilioPhone . '<br>';
        echo '4. Access your app at: ' . $baseUrl . '/<br>';
        echo '</div>';
        echo '</div>';
        ?>

        <div class="test-section">
            <h2>🔧 Quick Fixes</h2>
            <div class="code">
# If you need to run Laravel commands via SSH:
cd /home/princedevops/public_html/dizzcall-ai
php artisan key:generate
php artisan migrate
php artisan config:cache
php artisan route:cache
            </div>
        </div>

        <div class="test-section">
            <h2>📞 Support</h2>
            <p>If you encounter issues:</p>
            <ul>
                <li>Check cPanel error logs</li>
                <li>Verify file permissions</li>
                <li>Ensure database credentials are correct</li>
                <li>Test with a simple PHP file first</li>
            </ul>
        </div>
    </div>
</body>
</html>

