<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard Section -->
    <div id="dashboard-section">
        <div class="row mb-4">
            <div class="col-md-6 mb-4 mb-md-0">
                <div class="wallet-balance">
                    <div class="balance-header">
                        <h3 class="balance-title">Wallet Balance</h3>
                        <span class="badge"><?php echo e(($walletBalance ?? 0) > 0 ? 'Active' : 'Inactive'); ?></span>
                    </div>
                    <h2 class="balance-amount" id="current-balance">₹ <?php echo e(number_format($walletBalance ?? 0, 2)); ?></h2>
                    <p class="balance-info">Last recharge: <?php echo e(optional($lastRecharge?->created_at)->format('M d, Y h:i A') ?? '—'); ?></p>
                    <a class="recharge-btn" href="<?php echo e(route('wallet.topup')); ?>">
                        <i class="fas fa-plus-circle"></i> Recharge Wallet
                    </a>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-4 col-sm-4 mb-3">
                        <div class="stat-card">
                            <div class="stat-icon calls-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="stat-title">Total Calls</div>
                            <div class="stat-value" id="today-total-calls"><?php echo e($totalCalls ?? 0); ?></div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 mb-3">
                        <div class="stat-card">
                            <div class="stat-icon duration-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="stat-title">Total Duration</div>
                            <div class="stat-value" id="today-total-duration"><?php echo e(sprintf('%02d:%02d', floor(($totalDurationSeconds ?? 0)/60), ($totalDurationSeconds ?? 0)%60)); ?></div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 mb-3">
                        <div class="stat-card">
                            <div class="stat-icon money-icon">
                                <i class="fas fa-indian-rupee-sign"></i>
                            </div>
                            <div class="stat-title">Money Used</div>
                            <div class="stat-value" id="today-total-money">₹ <?php echo e(number_format($totalMoney ?? 0, 2)); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Activity Section -->
        <div class="row mb-4">
            <div class="col-md-12">
                <div class="activity-container">
                    <div class="table-header">
                        <h3 class="table-title">Recent Activity</h3>
                    </div>
                    <ul class="activity-list">
                        <li class="activity-item">
                            <div class="activity-icon call-activity">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="activity-content">
                                <h4>Call Completed</h4>
                                <p>Call with John Doe lasted 5 minutes 12 seconds</p>
                            </div>
                            <span class="activity-time">2 hours ago</span>
                        </li>
                        <li class="activity-item">
                            <div class="activity-icon recharge-activity">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="activity-content">
                                <h4>Wallet Recharged</h4>
                                <p>Added ₹1,000 to your wallet</p>
                            </div>
                            <span class="activity-time">1 day ago</span>
                        </li>
                        <li class="activity-item">
                            <div class="activity-icon system-activity">
                                <i class="fas fa-bell"></i>
                            </div>
                            <div class="activity-content">
                                <h4>New Feature Added</h4>
                                <p>Call scheduling feature is now available</p>
                            </div>
                            <span class="activity-time">2 days ago</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Recent Calls Table -->
        <div class="table-container">
            <div class="table-header">
                <h3 class="table-title">Recent Calls</h3>
                <button class="btn btn-primary">
                    <i class="fas fa-list"></i> View All Calls
                </button>
            </div>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Call ID</th>
                            <th>Contact Name</th>
                            <th>Contact No.</th>
                            <th>Date/Time</th>
                            <th>Duration</th>
                            <th>Cost</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="recent-calls-body">
                        <?php $__empty_1 = true; $__currentLoopData = ($recentCalls ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(data_get($call, 'call_id') ?? data_get($call, 'id')); ?></td>
                            <td><?php echo e(data_get($call, 'contact_name') ?? '—'); ?></td>
                            <td><?php echo e(data_get($call, 'phone_number') ?? '—'); ?></td>
                            <?php ($dt = data_get($call, 'date_time')); ?>
                            <td><?php echo e($dt ? \Illuminate\Support\Carbon::parse($dt)->format('M d, Y h:i A') : '—'); ?></td>
                            <?php ($dur = (int) (data_get($call, 'duration') ?? 0)); ?>
                            <td><?php echo e(sprintf('%02d:%02d', floor($dur/60), $dur%60)); ?></td>
                            <?php ($cost = (float) (data_get($call, 'cost') ?? 0)); ?>
                            <td>₹ <?php echo e(number_format($cost, 2)); ?></td>
                            <?php ($status = data_get($call, 'status', 'active')); ?>
                            <td>
                                <span class="status <?php echo e($status === 'completed' ? 'completed' : ($status === 'pending' ? 'pending' : 'active')); ?>">
                                    <?php echo e(ucfirst($status)); ?>

                                </span>
                            </td>
                            <td>
                                <button class="action-btn" title="View Transcript"><i class="fas fa-file-alt"></i></button>
                                <button class="action-btn" title="View Summary"><i class="fas fa-list"></i></button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">No recent calls.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Scheduled Calls Table -->
        <div class="table-container">
            <div class="table-header">
                <h3 class="table-title">Scheduled Calls</h3>
                <button class="btn btn-primary">
                    <i class="fas fa-plus"></i> Schedule New Call
                </button>
            </div>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Call ID</th>
                            <th>Contact</th>
                            <th>Scheduled Date/Time</th>
                            <th>Purpose</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="scheduled-calls-body">
                        <?php $__empty_1 = true; $__currentLoopData = ($scheduledCalls ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(data_get($call, 'call_id') ?? data_get($call, 'id')); ?></td>
                            <td><?php echo e(data_get($call, 'contact_name') ?? '—'); ?></td>
                            <?php ($sdt = data_get($call, 'date_time')); ?>
                            <td><?php echo e($sdt ? \Illuminate\Support\Carbon::parse($sdt)->format('M d, Y h:i A') : '—'); ?></td>
                            <td><?php echo e(data_get($call, 'purpose') ?? '—'); ?></td>
                            <td><span class="status pending">Pending</span></td>
                            <td>
                                <button class="action-btn" title="Edit"><i class="fas fa-edit"></i></button>
                                <button class="action-btn danger" title="Cancel"><i class="fas fa-times"></i></button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">No scheduled calls.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Enhance table rows on hover
            document.querySelectorAll('tr').forEach(row => {
                row.addEventListener('mouseenter', () => {
                    row.style.transform = 'scale(1.01)';
                    row.style.boxShadow = '0 4px 8px rgba(0,0,0,0.1)';
                });
                row.addEventListener('mouseleave', () => {
                    row.style.transform = 'scale(1)';
                    row.style.boxShadow = 'none';
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/home.blade.php ENDPATH**/ ?>