

<?php $__env->startSection('title', 'User Details: ' . $user->name); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">User Details: <?php echo e($user->name); ?></h3>
                    <div>
                        <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Users
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">System Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">User ID:</div>
                                        <div class="col-sm-8"><?php echo e($user->user_id ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Email:</div>
                                        <div class="col-sm-8"><?php echo e($user->email); ?></div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Status:</div>
                                        <div class="col-sm-8">
                                            <span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : ($user->status === 'inactive' ? 'warning' : 'danger')); ?>">
                                                <?php echo e(ucfirst($user->status)); ?>

                                            </span>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Registered:</div>
                                        <div class="col-sm-8"><?php echo e($user->created_at?->format('M d, Y h:i A') ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4 fw-bold">Last Updated:</div>
                                        <div class="col-sm-8"><?php echo e($user->updated_at?->format('M d, Y h:i A') ?? 'N/A'); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Company Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Company Name:</div>
                                        <div class="col-sm-8"><?php echo e($user->company_name ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Business Type:</div>
                                        <div class="col-sm-8"><?php echo e($user->business_type ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Contact Number:</div>
                                        <div class="col-sm-8"><?php echo e($user->contact_number ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Alternate Number:</div>
                                        <div class="col-sm-8"><?php echo e($user->alternate_number ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Website:</div>
                                        <div class="col-sm-8">
                                            <?php if($user->website): ?>
                                                <a href="<?php echo e($user->website); ?>" target="_blank"><?php echo e($user->website); ?></a>
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4 fw-bold">GSTIN:</div>
                                        <div class="col-sm-8"><?php echo e($user->gstin ?? 'N/A'); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Address</h5>
                        </div>
                        <div class="card-body">
                            <p><?php echo e($user->address ?? 'N/A'); ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Wallet</h5>
                                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#creditWalletModal">
                                        <i class="fas fa-plus-circle"></i> Add Funds
                                    </button>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-2">
                                        <div class="col-sm-6 fw-bold">Current Balance</div>
                                        <div class="col-sm-6">₹ <?php echo e(number_format($user->wallet_balance ?? 0, 2)); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Recent Wallet Transactions</h5>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-striped mb-0">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Type</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = ($transactions ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $txn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($txn->created_at?->format('M d, Y h:i A') ?? 'N/A'); ?></td>
                                                    <td><span class="badge bg-<?php echo e($txn->type === 'credit' ? 'success' : 'danger'); ?>"><?php echo e(ucfirst($txn->type ?? 'N/A')); ?></span></td>
                                                    <td>₹ <?php echo e(number_format($txn->amount ?? 0, 2)); ?></td>
                                                    <td>
                                                        <span class="badge bg-<?php echo e($txn->status === 'completed' ? 'success' : ($txn->status === 'pending' ? 'warning' : 'danger')); ?>">
                                                            <?php echo e(ucfirst($txn->status ?? 'N/A')); ?>

                                                        </span>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="4" class="text-center text-muted">No transactions found.</td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <?php if($user->license): ?>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">License Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">License Key:</div>
                                        <div class="col-sm-8">
                                            <code><?php echo e($user->license?->key ?? 'N/A'); ?></code>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Expiry Date:</div>
                                        <div class="col-sm-8">
                                            <?php echo e($user->license?->expires_at?->format('M d, Y') ?? 'N/A'); ?>

                                            <?php if($user->license?->expires_at): ?>
                                            <span class="badge bg-<?php echo e($user->license->expires_at->isFuture() ? 'success' : 'danger'); ?> ms-2">
                                                <?php echo e($user->license->expires_at->isFuture() ? 'Valid' : 'Expired'); ?>

                                            </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Status:</div>
                                        <div class="col-sm-8">
                                            <span class="badge bg-<?php echo e($user->license?->is_active ? 'success' : 'danger'); ?>">
                                                <?php echo e($user->license?->is_active ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Created:</div>
                                        <div class="col-sm-8"><?php echo e($user->license?->created_at?->format('M d, Y h:i A') ?? 'N/A'); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-warning">
                        No license associated with this user.
                    </div>
                    <?php endif; ?>
                    
                    <!-- Credit Wallet Modal -->
                    <div class="modal fade" id="creditWalletModal" tabindex="-1" aria-labelledby="creditWalletModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="creditWalletModalLabel">Add Funds to Wallet</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form method="POST" action="<?php echo e(route('admin.users.wallet.credit', $user->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <label for="amount" class="form-label">Amount (INR)</label>
                                            <input id="amount" name="amount" type="number" min="1" step="1" class="form-control" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="note" class="form-label">Note (optional)</label>
                                            <input id="note" name="note" type="text" class="form-control" maxlength="255">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary">Credit Wallet</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/admin/users/show.blade.php ENDPATH**/ ?>