<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Chat Streaming - DizzCall AI CRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .chat-container {
            height: 85vh;
            display: flex;
            flex-direction: column;
        }
        .chat-messages {
            flex: 1;
            overflow-y: auto;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .message {
            margin-bottom: 15px;
            padding: 12px 16px;
            border-radius: 18px;
            max-width: 75%;
            word-wrap: break-word;
            animation: fadeIn 0.3s ease-in;
        }
        .message.user {
            background-color: #007bff;
            color: white;
            margin-left: auto;
            text-align: right;
        }
        .message.ai {
            background-color: white;
            color: #333;
            border: 1px solid #dee2e6;
            margin-right: auto;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .message.system {
            background-color: #e9ecef;
            color: #6c757d;
            text-align: center;
            margin: 0 auto;
            font-style: italic;
            max-width: 90%;
        }
        .typing-indicator {
            display: none;
            padding: 12px 16px;
            background-color: white;
            border: 1px solid #dee2e6;
            border-radius: 18px;
            margin-right: auto;
            max-width: 75%;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .typing-indicator.show {
            display: block;
        }
        .typing-dots {
            display: inline-block;
        }
        .typing-dots span {
            display: inline-block;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: #6c757d;
            margin: 0 2px;
            animation: typing 1.4s infinite ease-in-out;
        }
        .typing-dots span:nth-child(1) { animation-delay: -0.32s; }
        .typing-dots span:nth-child(2) { animation-delay: -0.16s; }
        @keyframes typing {
            0%, 80%, 100% { transform: scale(0); }
            40% { transform: scale(1); }
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .chat-input {
            padding: 20px;
            background-color: white;
            border-top: 1px solid #dee2e6;
        }
        .insight-badge {
            display: inline-block;
            padding: 3px 8px;
            margin: 2px;
            border-radius: 12px;
            font-size: 0.75rem;
            background-color: #e3f2fd;
            color: #1976d2;
        }
        .streaming-text {
            border-right: 2px solid #007bff;
            animation: blink 1s infinite;
        }
        @keyframes blink {
            0%, 50% { border-color: #007bff; }
            51%, 100% { border-color: transparent; }
        }
        .message-time {
            font-size: 0.7em;
            opacity: 0.7;
            margin-top: 4px;
        }
        .connection-status {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
    </style>
</head>
<body>
    <div class="connection-status">
        <span class="badge bg-success" id="connectionStatus">
            <i class="fas fa-circle"></i> Connected
        </span>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">
                                <i class="fas fa-robot"></i> AI Voice Agent - Live Chat
                            </h4>
                            <div>
                                <button class="btn btn-sm btn-outline-light" id="clearChat">
                                    <i class="fas fa-trash"></i> Clear
                                </button>
                                <button class="btn btn-sm btn-outline-light ms-2" id="toggleStreaming">
                                    <i class="fas fa-stream"></i> Streaming
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="chat-container">
                            <div class="chat-messages" id="chatMessages">
                                <div class="message system">
                                    <i class="fas fa-robot"></i> Welcome to DizzCall AI Voice Agent! 
                                    <br>I can help you with sales, support, and general questions. How can I assist you today?
                                </div>
                            </div>
                            <div class="typing-indicator" id="typingIndicator">
                                <div class="typing-dots">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                                AI is thinking...
                            </div>
                            <div class="chat-input">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="messageInput" 
                                           placeholder="Type your message here..." 
                                           onkeypress="handleKeyPress(event)">
                                    <button class="btn btn-primary" type="button" id="sendButton" onclick="sendMessage()">
                                        <i class="fas fa-paper-plane"></i>
                                    </button>
                                </div>
                                <div class="mt-2 d-flex justify-content-between">
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle"></i> 
                                        Real-time AI responses with live streaming
                                    </small>
                                    <small class="text-muted" id="streamingStatus">
                                        <i class="fas fa-stream"></i> Streaming enabled
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let currentConversationId = null;
        let isTyping = false;
        let streamingEnabled = true;
        let currentStreamingMessage = null;

        // Initialize chat
        document.addEventListener('DOMContentLoaded', function() {
            testConnection();
            setupEventListeners();
        });

        function setupEventListeners() {
            document.getElementById('clearChat').addEventListener('click', clearChat);
            document.getElementById('toggleStreaming').addEventListener('click', toggleStreaming);
        }

        function handleKeyPress(event) {
            if (event.key === 'Enter') {
                sendMessage();
            }
        }

        function testConnection() {
            fetch('/api/ai/test-connection', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                const status = document.getElementById('connectionStatus');
                if (data.success) {
                    status.className = 'badge bg-success';
                    status.innerHTML = '<i class="fas fa-circle"></i> Connected';
                } else {
                    status.className = 'badge bg-danger';
                    status.innerHTML = '<i class="fas fa-circle"></i> Disconnected';
                }
            })
            .catch(error => {
                const status = document.getElementById('connectionStatus');
                status.className = 'badge bg-warning';
                status.innerHTML = '<i class="fas fa-circle"></i> Testing...';
            });
        }

        function sendMessage() {
            const input = document.getElementById('messageInput');
            const message = input.value.trim();
            
            if (!message || isTyping) return;

            // Add user message to chat
            addMessage('user', message);
            input.value = '';

            // Show typing indicator
            showTypingIndicator();

            // Send to AI
            sendToAI(message);
        }

        function sendToAI(message) {
            const url = currentConversationId 
                ? `/api/ai/conversations/${currentConversationId}/message`
                : '/api/ai/conversations/start';

            const payload = currentConversationId 
                ? { message: message }
                : { 
                    type: 'general', 
                    context: { source: 'web_chat_streaming' },
                    message: message 
                  };

            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(payload)
            })
            .then(response => response.json())
            .then(data => {
                hideTypingIndicator();
                
                if (data.success) {
                    if (!currentConversationId && data.conversation) {
                        currentConversationId = data.conversation.id;
                    }
                    
                    // Add AI response
                    if (data.data && data.data.ai_message) {
                        if (streamingEnabled) {
                            streamMessage(data.data.ai_message.content);
                        } else {
                            addMessage('ai', data.data.ai_message.content);
                        }
                        
                        // Show insights if available
                        if (data.data.insights && data.data.insights.length > 0) {
                            showInsights(data.data.insights);
                        }
                    } else if (data.response) {
                        if (streamingEnabled) {
                            streamMessage(data.response);
                        } else {
                            addMessage('ai', data.response);
                        }
                    }
                } else {
                    addMessage('ai', 'Sorry, I encountered an error. Please try again.');
                }
            })
            .catch(error => {
                hideTypingIndicator();
                console.error('Error:', error);
                addMessage('ai', 'Sorry, I encountered an error. Please try again.');
            });
        }

        function streamMessage(text) {
            const messagesContainer = document.getElementById('chatMessages');
            const messageDiv = document.createElement('div');
            messageDiv.className = 'message ai';
            
            const time = new Date().toLocaleTimeString();
            messageDiv.innerHTML = `
                <div id="streamingContent"></div>
                <div class="message-time">${time}</div>
            `;
            
            messagesContainer.appendChild(messageDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
            
            const contentDiv = messageDiv.querySelector('#streamingContent');
            currentStreamingMessage = contentDiv;
            
            // Simulate streaming by adding characters one by one
            let index = 0;
            const streamInterval = setInterval(() => {
                if (index < text.length) {
                    contentDiv.textContent = text.substring(0, index + 1);
                    contentDiv.classList.add('streaming-text');
                    messagesContainer.scrollTop = messagesContainer.scrollHeight;
                    index++;
                } else {
                    clearInterval(streamInterval);
                    contentDiv.classList.remove('streaming-text');
                    currentStreamingMessage = null;
                }
            }, 30); // Adjust speed as needed
        }

        function addMessage(type, content) {
            const messagesContainer = document.getElementById('chatMessages');
            const messageDiv = document.createElement('div');
            messageDiv.className = `message ${type}`;
            
            const time = new Date().toLocaleTimeString();
            messageDiv.innerHTML = `
                <div>${content}</div>
                <div class="message-time">${time}</div>
            `;
            
            messagesContainer.appendChild(messageDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }

        function showInsights(insights) {
            const messagesContainer = document.getElementById('chatMessages');
            const insightDiv = document.createElement('div');
            insightDiv.className = 'message system';
            insightDiv.style.marginTop = '5px';
            
            let insightHtml = '<small><i class="fas fa-lightbulb"></i> AI Insights: ';
            insights.forEach(insight => {
                insightHtml += `<span class="insight-badge">${insight.type}: ${insight.content}</span>`;
            });
            insightHtml += '</small>';
            
            insightDiv.innerHTML = insightHtml;
            messagesContainer.appendChild(insightDiv);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }

        function showTypingIndicator() {
            isTyping = true;
            document.getElementById('typingIndicator').classList.add('show');
            document.getElementById('sendButton').disabled = true;
        }

        function hideTypingIndicator() {
            isTyping = false;
            document.getElementById('typingIndicator').classList.remove('show');
            document.getElementById('sendButton').disabled = false;
        }

        function clearChat() {
            const messagesContainer = document.getElementById('chatMessages');
            messagesContainer.innerHTML = `
                <div class="message system">
                    <i class="fas fa-robot"></i> Chat cleared. How can I help you today?
                </div>
            `;
            currentConversationId = null;
        }

        function toggleStreaming() {
            streamingEnabled = !streamingEnabled;
            const button = document.getElementById('toggleStreaming');
            const status = document.getElementById('streamingStatus');
            
            if (streamingEnabled) {
                button.innerHTML = '<i class="fas fa-stream"></i> Streaming';
                button.className = 'btn btn-sm btn-outline-light';
                status.innerHTML = '<i class="fas fa-stream"></i> Streaming enabled';
            } else {
                button.innerHTML = '<i class="fas fa-stop"></i> Normal';
                button.className = 'btn btn-sm btn-warning';
                status.innerHTML = '<i class="fas fa-stop"></i> Normal mode';
            }
        }
    </script>
</body>
</html>
<?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/ai-chat-streaming.blade.php ENDPATH**/ ?>