

<?php $__env->startSection('title', 'Account Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Account Settings</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Profile Settings</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('user.settings.profile.update')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-3">
                                            <label class="form-label">Full Name</label>
                                            <input type="text" class="form-control" name="name" value="<?php echo e(old('name', $user->name)); ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Email Address</label>
                                            <input type="email" class="form-control" name="email" value="<?php echo e(old('email', $user->email)); ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Phone Number</label>
                                            <input type="text" class="form-control" name="contact_number" value="<?php echo e(old('contact_number', $user->contact_number)); ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Company Name</label>
                                            <input type="text" class="form-control" name="company_name" value="<?php echo e(old('company_name', $user->company_name)); ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Theme</label>
                                            <select class="form-select" name="theme">
                                                <option value="light" <?php echo e(old('theme', $user->theme) === 'light' ? 'selected' : ''); ?>>Light</option>
                                                <option value="dark" <?php echo e(old('theme', $user->theme) === 'dark' ? 'selected' : ''); ?>>Dark</option>
                                            </select>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Address</label>
                                            <textarea class="form-control" name="address"><?php echo e(old('address', $user->address)); ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Website</label>
                                            <input type="url" class="form-control" name="website" value="<?php echo e(old('website', $user->website)); ?>">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Update Profile</button>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Security Settings</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('user.profile.password')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-3">
                                            <label class="form-label">Current Password</label>
                                            <input type="password" class="form-control" name="current_password" placeholder="Enter current password">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">New Password</label>
                                            <input type="password" class="form-control" name="new_password" placeholder="Enter new password">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Confirm New Password</label>
                                            <input type="password" class="form-control" name="new_password_confirmation" placeholder="Confirm new password">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Change Password</button>
                                    </form>
                                </div>
                            </div>

                            <div class="card mt-4">
                                <div class="card-header">
                                    <h5>Notification Preferences</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('user.settings.notifications.update')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" name="email" id="emailNotifications" <?php echo e(old('email', true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="emailNotifications">Email Notifications</label>
                                        </div>
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" name="sms" id="smsNotifications">
                                            <label class="form-check-label" for="smsNotifications">SMS Notifications</label>
                                        </div>
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" name="low_balance" id="lowBalanceAlert" <?php echo e(old('low_balance', true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="lowBalanceAlert">Low Balance Alerts</label>
                                        </div>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" name="weekly_reports" id="callReports" <?php echo e(old('weekly_reports', true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="callReports">Weekly Call Reports</label>
                                        </div>
                                        <button type="submit" class="btn btn-primary mt-3">Save Preferences</button>
                                    </form>
                                        <label class="form-check-label" for="emailNotifications">Email Notifications</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="smsNotifications">
                                        <label class="form-check-label" for="smsNotifications">SMS Notifications</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="lowBalanceAlert" checked>
                                        <label class="form-check-label" for="lowBalanceAlert">Low Balance Alerts</label>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="callReports" checked>
                                        <label class="form-check-label" for="callReports">Weekly Call Reports</label>
                                    </div>
                                    <button type="submit" class="btn btn-primary mt-3">Save Preferences</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5>API Settings</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('user.settings.api.update')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-3">
                                            <label class="form-label">Webhook URL</label>
                                            <input type="url" class="form-control" name="webhook_url" placeholder="https://example.com/webhook" value="<?php echo e(old('webhook_url')); ?>">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Save API Settings</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/FrontUser/settings/index.blade.php ENDPATH**/ ?>