<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard Section -->
    <div id="dashboard-section">
        <div class="row mb-4">
            <div class="col-md-6 mb-4 mb-md-0">
                <div class="wallet-balance">
                    <div class="balance-header">
                        <h3 class="balance-title">Wallet Balance</h3>
                        <span class="badge"><?php echo e(($walletBalance ?? 0) > 0 ? 'Active' : 'Inactive'); ?></span>
                    </div>
                    <h2 class="balance-amount" id="current-balance">₹ <?php echo e(number_format($walletBalance ?? 0, 2)); ?></h2>
                    <p class="balance-info">Last recharge: <?php echo e(optional($lastRecharge?->created_at)->format('M d, Y h:i A') ?? '—'); ?></p>
                    <a class="recharge-btn" href="<?php echo e(route('wallet.topup')); ?>">
                        <i class="fas fa-plus-circle"></i> Recharge Wallet
                    </a>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-4 col-sm-4 mb-3">
                        <div class="stat-card">
                            <div class="stat-icon calls-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="stat-title">Total Calls</div>
                            <div class="stat-value" id="today-total-calls"><?php echo e($totalCalls ?? 0); ?></div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 mb-3">
                        <div class="stat-card">
                            <div class="stat-icon duration-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="stat-title">Total Duration</div>
                            <div class="stat-value" id="today-total-duration"><?php echo e(sprintf('%02d:%02d', floor(($totalDurationSeconds ?? 0)/60), ($totalDurationSeconds ?? 0)%60)); ?></div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 mb-3">
                        <div class="stat-card">
                            <div class="stat-icon money-icon">
                                <i class="fas fa-indian-rupee-sign"></i>
                            </div>
                            <div class="stat-title">Money Used</div>
                            <div class="stat-value" id="today-total-money">₹ <?php echo e(number_format($totalMoney ?? 0, 2)); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="chart-container">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h3 class="table-title m-0">Calls (7 days)</h3>
                    </div>
                    <canvas id="callsChart" height="120"></canvas>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="chart-container">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h3 class="table-title m-0">Spend (7 days)</h3>
                    </div>
                    <canvas id="spendChart" height="120"></canvas>
                </div>
            </div>
        </div>

        <!-- Recent Calls Table -->
        <div class="table-container">
            <div class="table-header">
                <h3 class="table-title">Recent Calls</h3>
                <button class="btn btn-primary">
                    <i class="fas fa-list"></i> View All Calls
                </button>
            </div>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Call ID</th>
                            <th>Contact Name</th>
                            <th>Contact No.</th>
                            <th>Date/Time</th>
                            <th>Duration</th>
                            <th>Cost</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="recent-calls-body">
                        <?php $__empty_1 = true; $__currentLoopData = ($recentCalls ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(data_get($call, 'call_id') ?? data_get($call, 'id')); ?></td>
                            <td><?php echo e(data_get($call, 'contact_name') ?? '—'); ?></td>
                            <td><?php echo e(data_get($call, 'phone_number') ?? '—'); ?></td>
                            <?php ($dt = data_get($call, 'date_time')); ?>
                            <td><?php echo e($dt ? \Illuminate\Support\Carbon::parse($dt)->format('M d, Y h:i A') : '—'); ?></td>
                            <?php ($dur = (int) (data_get($call, 'duration') ?? 0)); ?>
                            <td><?php echo e(sprintf('%02d:%02d', floor($dur/60), $dur%60)); ?></td>
                            <?php ($cost = (float) (data_get($call, 'cost') ?? 0)); ?>
                            <td>₹ <?php echo e(number_format($cost, 2)); ?></td>
                            <?php ($status = data_get($call, 'status', 'active')); ?>
                            <td>
                                <span class="status <?php echo e($status === 'completed' ? 'completed' : ($status === 'pending' ? 'pending' : 'active')); ?>">
                                    <?php echo e(ucfirst($status)); ?>

                                </span>
                            </td>
                            <td>
                                <button class="action-btn" title="View Transcript"><i class="fas fa-file-alt"></i></button>
                                <button class="action-btn" title="View Summary"><i class="fas fa-list"></i></button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">No recent calls.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Scheduled Calls Table -->
        <div class="table-container">
            <div class="table-header">
                <h3 class="table-title">Scheduled Calls</h3>
                <button class="btn btn-primary">
                    <i class="fas fa-plus"></i> Schedule New Call
                </button>
            </div>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Call ID</th>
                            <th>Contact</th>
                            <th>Scheduled Date/Time</th>
                            <th>Purpose</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="scheduled-calls-body">
                        <?php $__empty_1 = true; $__currentLoopData = ($scheduledCalls ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(data_get($call, 'call_id') ?? data_get($call, 'id')); ?></td>
                            <td><?php echo e(data_get($call, 'contact_name') ?? '—'); ?></td>
                            <?php ($sdt = data_get($call, 'date_time')); ?>
                            <td><?php echo e($sdt ? \Illuminate\Support\Carbon::parse($sdt)->format('M d, Y h:i A') : '—'); ?></td>
                            <td><?php echo e(data_get($call, 'purpose') ?? '—'); ?></td>
                            <td><span class="status pending">Pending</span></td>
                            <td>
                                <button class="action-btn" title="Edit"><i class="fas fa-edit"></i></button>
                                <button class="action-btn danger" title="Cancel"><i class="fas fa-times"></i></button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">No scheduled calls.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Charts
            const labels = <?php echo json_encode($chartLabels ?? [], 15, 512) ?>;
            const calls = <?php echo json_encode($chartCalls ?? [], 15, 512) ?>;
            const spend = <?php echo json_encode($chartSpend ?? [], 15, 512) ?>;
            const durationMins = <?php echo json_encode($chartDurationMinutes ?? [], 15, 512) ?>;

            const callsCtx = document.getElementById('callsChart');
            if (callsCtx && window.Chart) {
                new Chart(callsCtx, {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [
                            { label: 'Calls', data: calls, borderColor: '#4361ee', backgroundColor: 'rgba(67,97,238,0.2)', tension: 0.3, fill: true },
                            { label: 'Duration (mins)', data: durationMins, borderColor: '#4ade80', backgroundColor: 'rgba(74,222,128,0.2)', tension: 0.3, fill: true }
                        ]
                    },
                    options: { responsive: true, plugins: { legend: { position: 'bottom' } }, scales: { y: { beginAtZero: true } } }
                });
            }

            const spendCtx = document.getElementById('spendChart');
            if (spendCtx && window.Chart) {
                new Chart(spendCtx, {
                    type: 'bar',
                    data: {
                        labels: labels,
                        datasets: [
                            { label: 'Spend (₹)', data: spend, backgroundColor: 'rgba(247,37,133,0.6)', borderColor: '#f72585' }
                        ]
                    },
                    options: { responsive: true, plugins: { legend: { position: 'bottom' } }, scales: { y: { beginAtZero: true } } }
                });
            }
            // Enhance table rows on hover
            document.querySelectorAll('tr').forEach(row => {
                row.addEventListener('mouseenter', () => {
                    row.style.transform = 'scale(1.01)';
                    row.style.boxShadow = '0 4px 8px rgba(0,0,0,0.1)';
                });
                row.addEventListener('mouseleave', () => {
                    row.style.transform = 'scale(1)';
                    row.style.boxShadow = 'none';
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/FrontUser/home.blade.php ENDPATH**/ ?>