<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conversation_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained()->onDelete('cascade');
            $table->enum('role', ['user', 'assistant', 'system']);
            $table->text('content');
            $table->json('metadata')->nullable();
            $table->timestamp('timestamp');
            $table->enum('sentiment', ['positive', 'negative', 'neutral'])->nullable();
            $table->decimal('confidence_score', 3, 2)->nullable();
            $table->integer('processing_time_ms')->nullable();
            $table->timestamps();
            
            $table->index(['conversation_id', 'timestamp']);
            $table->index(['role', 'sentiment']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conversation_messages');
    }
};
